/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.extension;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.dromara.hodor.common.extension.ExtensionFactory;
import org.dromara.hodor.common.extension.Join;
import org.dromara.hodor.common.extension.SPI;
import org.dromara.hodor.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader<T> {
    private final Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String EXTENSION_DIRECTORY = "META-INF/hodor/";
    private static final Map<Class<?>, ExtensionLoader<?>> LOADERS = new ConcurrentHashMap();
    private final Class<T> clazz;
    private final Class<?> argClass;
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final Holder<Map<String, String>> cachedClassesMap = new Holder();
    private final Map<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Map<Class<?>, Object> joinInstances = new ConcurrentHashMap();
    private String cachedDefaultName;

    private ExtensionLoader(Class<T> clazz, Class<?> argClass) {
        this.clazz = clazz;
        this.argClass = argClass;
        if (clazz != ExtensionFactory.class) {
            ExtensionLoader.getExtensionLoader(ExtensionFactory.class).getExtensionClasses();
        }
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz, Class<?> argClass) {
        if (clazz == null) {
            throw new NullPointerException("extension clazz is null");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("extension clazz (" + clazz + "is not interface!");
        }
        if (!clazz.isAnnotationPresent(SPI.class)) {
            throw new IllegalArgumentException("extension clazz (" + clazz + " without @" + SPI.class + " Annotation");
        }
        ExtensionLoader<?> extensionLoader = LOADERS.get(clazz);
        if (extensionLoader != null) {
            return extensionLoader;
        }
        LOADERS.putIfAbsent(clazz, new ExtensionLoader<T>(clazz, argClass));
        return LOADERS.get(clazz);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz) {
        return ExtensionLoader.getExtensionLoader(clazz, null);
    }

    public T getDefaultJoin() {
        this.getExtensionClasses();
        if (StringUtils.isBlank(this.cachedDefaultName)) {
            return null;
        }
        return this.getJoin(this.cachedDefaultName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getJoin(String name) {
        if (StringUtils.isBlank(name)) {
            throw new NullPointerException("get join name is null");
        }
        try {
            Object value;
            Holder<Object> objectHolder = this.cachedInstances.get(name);
            if (objectHolder == null) {
                this.cachedInstances.putIfAbsent(name, new Holder());
                objectHolder = this.cachedInstances.get(name);
            }
            if ((value = objectHolder.getValue()) == null) {
                Map<String, Holder<Object>> map = this.cachedInstances;
                synchronized (map) {
                    value = objectHolder.getValue();
                    if (value == null) {
                        value = this.createExtension(name);
                        objectHolder.setValue(value);
                    }
                }
            }
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("According to the name [" + name + "] Can't find class");
        }
    }

    public T getProtoJoin(String name, Object ... args) {
        Class<?> aClass = this.getExtensionClasses().get(name);
        if (aClass == null) {
            throw new IllegalArgumentException("not found extension " + name);
        }
        try {
            if (this.argClass != null && ExtensionLoader.getConstructor(aClass, this.argClass) != null) {
                Constructor<?> constructor = ExtensionLoader.getConstructor(aClass, this.argClass);
                return (T)constructor.newInstance(args);
            }
            Object instance = aClass.newInstance();
            return (T)instance;
        }
        catch (Exception e) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + aClass + ")  could not be instantiated: " + e.getMessage(), e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> c, Class<?> ... args) {
        try {
            Constructor<?> cons = c.getConstructor(args);
            return cons;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private T createExtension(String name) {
        Class<?> aClass = this.getExtensionClasses().get(name);
        if (aClass == null) {
            throw new IllegalArgumentException("name is error");
        }
        Object o = this.joinInstances.get(aClass);
        if (o == null) {
            try {
                this.joinInstances.putIfAbsent(aClass, aClass.newInstance());
                o = this.joinInstances.get(aClass);
            }
            catch (Exception e) {
                throw new IllegalStateException("Extension instance(name: " + name + ", class: " + aClass + ")  could not be instantiated: " + e.getMessage(), e);
            }
        }
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.getValue();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.getValue();
                if (classes == null) {
                    classes = this.loadExtensionClass();
                    this.cachedClasses.setValue(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClass() {
        String value;
        SPI annotation = this.clazz.getAnnotation(SPI.class);
        if (annotation != null && StringUtils.isNotBlank(value = annotation.value())) {
            this.cachedDefaultName = value;
        }
        HashMap classes = new HashMap(16);
        this.loadDirectory(classes);
        return classes;
    }

    private void loadDirectory(Map<String, Class<?>> classes) {
        String fileName = EXTENSION_DIRECTORY + this.clazz.getName();
        try {
            Enumeration<URL> urls;
            ClassLoader classLoader = ExtensionLoader.class.getClassLoader();
            Enumeration<URL> enumeration = urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    this.loadResources(classes, url);
                }
            }
        }
        catch (Throwable t2) {
            this.logger.error("load extension class error {}", (Object)fileName, (Object)t2);
        }
    }

    private void loadResources(Map<String, Class<?>> classes, URL url) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String name = (String)k;
                String classPath = (String)v;
                if (StringUtils.isNotBlank(name) && StringUtils.isNotBlank(classPath)) {
                    try {
                        this.loadClass(classes, name, classPath);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("load extension resources error", e);
                    }
                }
            }));
        }
        catch (IOException e) {
            throw new IllegalStateException("load extension resources error", e);
        }
    }

    private void loadClass(Map<String, Class<?>> classes, String name, String classPath) throws ClassNotFoundException {
        Class<?> subClass = Class.forName(classPath);
        if (!this.clazz.isAssignableFrom(subClass)) {
            throw new IllegalStateException("load extension resources error," + subClass + " subtype is not of " + this.clazz);
        }
        Join annotation = subClass.getAnnotation(Join.class);
        if (annotation == null) {
            throw new IllegalStateException("load extension resources error," + subClass + "with Join annotation");
        }
        Class<?> oldClass = classes.get(name);
        if (oldClass == null) {
            classes.put(name, subClass);
        } else if (oldClass != subClass) {
            Join oldJoinAnnotation = oldClass.getAnnotation(Join.class);
            if (annotation.order() > oldJoinAnnotation.order()) {
                classes.put(name, subClass);
            }
        }
    }

    public static class Holder<T> {
        private volatile T value;

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

