/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.loadbalance;

import java.util.HashMap;
import java.util.Map;
import org.dromara.hodor.common.loadbalance.LoadBalance;
import org.dromara.hodor.common.loadbalance.LoadBalanceEnum;
import org.dromara.hodor.common.loadbalance.RandomLoadBalance;
import org.dromara.hodor.common.loadbalance.RoundRobinLoadBalance;
import org.dromara.hodor.common.utils.StringUtils;

public final class LoadBalanceFactory {
    private static final Map<String, LoadBalance> loadBalanceMap = new HashMap<String, LoadBalance>();

    public static LoadBalance getLoadBalance(String type) {
        return loadBalanceMap.computeIfAbsent(type, k -> {
            LoadBalanceEnum lb = LoadBalanceFactory.getLoadBalanceEnum(type);
            if (lb == LoadBalanceEnum.RANDOM) {
                return new RandomLoadBalance();
            }
            return new RoundRobinLoadBalance();
        });
    }

    private static LoadBalanceEnum getLoadBalanceEnum(String type) {
        try {
            return LoadBalanceEnum.valueOf(StringUtils.upperCase(type));
        }
        catch (Exception e) {
            return LoadBalanceEnum.ROUND_ROBIN;
        }
    }
}

