/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.log;

import java.io.File;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogUtil {
    private static final LogUtil INSTANCE = new LogUtil();
    public static final String DEFAULT_LAYOUT = "[%d{yyyy-MM-dd HH:mm:ss}] [%thread] %-5level %class{40}:%L %msg%n";
    private final LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
    private final Configuration config = this.ctx.getConfiguration();

    private LogUtil() {
    }

    public static LogUtil getInstance() {
        return INSTANCE;
    }

    public Logger createLogger(String loggerName, File logFile) {
        return this.createLogger(loggerName, logFile, DEFAULT_LAYOUT);
    }

    public Logger createLogger(String loggerName, File logFile, String layoutPattern) {
        return this.createLogger(loggerName, () -> this.buildFileAppender(loggerName, logFile, layoutPattern));
    }

    public Logger createRollingLogger(String loggerName, File logFile, String layoutPattern, int interval) {
        return this.createLogger(loggerName, () -> this.buildRollingFileAppender(loggerName, logFile, layoutPattern, interval));
    }

    public Logger createLogger(String loggerName, Supplier<Appender> appenderSupplier) {
        Logger logger = LogManager.getLogger(loggerName);
        Appender appender = appenderSupplier.get();
        appender.start();
        this.attachFileAppend(logger, appender);
        return logger;
    }

    public void attachFileAppend(Logger logger, Appender appender) {
        String loggerName = logger.getName();
        AppenderRef ref = AppenderRef.createAppenderRef(loggerName, null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger(false, Level.ALL, loggerName, "true", refs, null, this.config, null);
        loggerConfig.addAppender(appender, null, null);
        this.config.addAppender(appender);
        this.config.addLogger(loggerName, loggerConfig);
        this.ctx.updateLoggers();
    }

    public Appender buildFileAppender(String loggerName, File logFile, String layoutPattern) {
        PatternLayout layout = PatternLayout.newBuilder().withPattern(layoutPattern).build();
        return ((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setConfiguration(this.config)).withAppend(true)).setName(loggerName)).withFileName(logFile.getAbsolutePath())).setLayout(layout)).build();
    }

    public Appender buildRollingFileAppender(String loggerName, File logFile, String layoutPattern, int interval) {
        PatternLayout layout = PatternLayout.newBuilder().withPattern(layoutPattern).build();
        String fileName = logFile.getAbsolutePath();
        return ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)RollingFileAppender.newBuilder()).setConfiguration(this.config)).withAppend(true)).setName(loggerName)).withFileName(fileName)).withFilePattern(fileName + "_%d{yyyyMMddHHmmss}")).setLayout(layout)).withPolicy(TimeBasedTriggeringPolicy.newBuilder().withInterval(interval).withModulate(true).build())).withStrategy(DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(60 / interval * 60 * 24)).build())).build();
    }

    public void stopLogger(String loggerName) {
        this.config.getAppender(loggerName).stop();
        this.config.getLoggerConfig(loggerName).removeAppender(loggerName);
        this.config.removeLogger(loggerName);
        this.ctx.updateLoggers();
    }
}

