/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;

public final class KVMetrics {
    private static final MetricRegistry metricRegistry = new MetricRegistry();

    public static MetricRegistry metricRegistry() {
        return metricRegistry;
    }

    public static Meter meter(String name) {
        return metricRegistry.meter(Objects.requireNonNull(name, "name"));
    }

    public static Meter meter(String ... names) {
        return metricRegistry.meter(KVMetrics.name(names));
    }

    public static Timer timer(String name) {
        return metricRegistry.timer(Objects.requireNonNull(name, "name"));
    }

    public static Timer timer(String ... names) {
        return metricRegistry.timer(KVMetrics.name(names));
    }

    public static Counter counter(String name) {
        return metricRegistry.counter(Objects.requireNonNull(name, "name"));
    }

    public static Counter counter(String ... names) {
        return metricRegistry.counter(KVMetrics.name(names));
    }

    public static Histogram histogram(String name) {
        return metricRegistry.histogram(Objects.requireNonNull(name, "name"));
    }

    public static Histogram histogram(String ... names) {
        return metricRegistry.histogram(KVMetrics.name(names));
    }

    private static String name(String ... names) {
        StringBuilder buf = new StringBuilder();
        for (String name : names) {
            if (buf.length() > 0) {
                buf.append('_');
            }
            buf.append(name);
        }
        return buf.toString();
    }

    private KVMetrics() {
    }
}

