/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.queue;

import java.util.Queue;
import java.util.concurrent.ThreadPoolExecutor;
import org.dromara.hodor.common.queue.RejectedEnqueueHandler;

public class AdjustThreadSizePolicy<T>
implements RejectedEnqueueHandler<T> {
    private final ThreadPoolExecutor executor;

    public AdjustThreadSizePolicy(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void rejectedExecution(T e, Queue<T> queue) {
        int maximumPoolSize = this.executor.getMaximumPoolSize();
        if (maximumPoolSize >= 1000) {
            return;
        }
        this.executor.setMaximumPoolSize(maximumPoolSize + 10);
    }
}

