/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.queue;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dromara.hodor.common.queue.AbortEnqueuePolicy;
import org.dromara.hodor.common.queue.DiscardOldestElementPolicy;
import org.dromara.hodor.common.queue.RejectedEnqueueHandler;

public class CircleQueue<T>
extends AbstractQueue<T> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CAPACITY = 16;
    private Object[] elementData;
    private int size;
    private int head;
    private int tail;
    private RejectedEnqueueHandler<T> rejectedEnqueueHandler;

    public CircleQueue(int initialCapacity, RejectedEnqueueHandler<T> rejectedEnqueueHandler) {
        this.elementData = new Object[initialCapacity];
        this.rejectedEnqueueHandler = rejectedEnqueueHandler;
        this.size = 0;
        this.head = 0;
        this.tail = 0;
    }

    public CircleQueue(int initialCapacity) {
        this(initialCapacity, new AbortEnqueuePolicy());
    }

    public CircleQueue() {
        this(16);
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("un support iterator operation");
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.size;
    }

    public int getCapacity() {
        return this.elementData.length;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail && this.elementData[this.head] == null;
    }

    public boolean isFull() {
        return this.head == this.tail && this.elementData[this.head] != null;
    }

    public void resize(int newCapacity) {
        if (newCapacity <= 0) {
            return;
        }
        if (newCapacity < 16) {
            newCapacity = 16;
        }
        if (newCapacity <= this.size) {
            newCapacity = this.size + newCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = CircleQueue.hugeCapacity(newCapacity);
        }
        if (newCapacity == this.getCapacity()) {
            return;
        }
        Object[] newElementData = new Object[newCapacity];
        if (newElementData.length > this.elementData.length) {
            for (int i = this.head; i < this.size + this.tail; ++i) {
                newElementData[i] = this.elementData[i % this.size];
            }
            this.elementData = newElementData;
            this.tail = this.size + this.head;
        } else {
            System.arraycopy(this.elementData, this.head, newElementData, 0, this.size);
            this.elementData = newElementData;
            this.head = 0;
            this.tail = this.size;
        }
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public boolean offer(T e) {
        if (e == null) {
            throw new IllegalArgumentException("queue element must be not null.");
        }
        if (this.isFull()) {
            this.getRejectedEnqueueHandler().rejectedExecution(e, this);
            if (this.isFull()) {
                throw new IndexOutOfBoundsException("Exceed queue capacity, Please reset the enqueue rejection policy.");
            }
        }
        this.elementData[this.tail++] = e;
        this.tail = this.tail == this.elementData.length ? 0 : this.tail;
        ++this.size;
        return true;
    }

    @Override
    public T poll() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty, no such element to poll.");
        }
        Object t2 = this.elementData[this.head];
        this.elementData[this.head++] = null;
        this.head = this.head == this.elementData.length ? 0 : this.head;
        --this.size;
        if (this.size <= this.getCapacity() >> 2) {
            this.resize(this.getCapacity() >> 1);
        }
        return (T)t2;
    }

    @Override
    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.elementData[this.head];
    }

    public RejectedEnqueueHandler<T> getRejectedEnqueueHandler() {
        if (this.rejectedEnqueueHandler == null) {
            this.rejectedEnqueueHandler = new DiscardOldestElementPolicy();
        }
        return this.rejectedEnqueueHandler;
    }

    public void setRejectedEnqueueHandler(RejectedEnqueueHandler<T> rejectedEnqueueHandler) {
        this.rejectedEnqueueHandler = rejectedEnqueueHandler;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Queue size: %s, capacity: %s;", this.size(), this.getCapacity()));
        sb.append("\n");
        sb.append("[");
        if (this.tail > this.head) {
            for (int i = this.head; i < this.tail; ++i) {
                sb.append(this.elementData[i].toString()).append(", ");
            }
        } else {
            for (int i = this.head; i < this.size + this.tail; ++i) {
                sb.append(this.elementData[i % this.size].toString()).append(",");
            }
        }
        return sb.substring(0, sb.length() - 1) + "]";
    }
}

