/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.NetUtils;
import org.dromara.hodor.common.raft.HodorRaftGroup;
import org.dromara.hodor.common.raft.HodorRaftStateMachine;
import org.dromara.hodor.common.raft.RaftGroupManager;
import org.dromara.hodor.common.raft.RaftOptions;
import org.dromara.hodor.common.raft.RaftUtils;
import org.dromara.hodor.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HodorRaftServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HodorRaftServer.class);
    private final Map<RaftGroupId, StateMachine> registry = new ConcurrentHashMap<RaftGroupId, StateMachine>();
    private final RaftOptions raftOptions;
    private final String endpoint;
    private final File storageDir;
    private final RaftProperties raftProperties;
    private final Parameters parameters;
    private RaftServer server;
    private RaftPeer currentPeer;

    public HodorRaftServer(RaftOptions raftOptions) throws IOException {
        Utils.Assert.notNull(raftOptions, "raftOptions must not be null.", new Object[0]);
        this.raftOptions = raftOptions;
        this.endpoint = raftOptions.getEndpoint();
        this.storageDir = raftOptions.getStorageDir();
        this.raftProperties = raftOptions.getRaftProperties();
        this.parameters = raftOptions.getParameters();
        this.init();
    }

    private void init() throws IOException {
        this.currentPeer = RaftGroupManager.getInstance().buildRaftPeer(NetUtils.createSocketAddr(this.endpoint), 0);
        RaftServerConfigKeys.setStorageDir(this.raftProperties, Collections.singletonList(new File(this.storageDir, this.currentPeer.getId().toString())));
        int port = NetUtils.createSocketAddr(this.currentPeer.getAddress()).getPort();
        GrpcConfigKeys.Server.setPort(this.raftProperties, port);
        this.initRaftGroup(this.raftOptions.getStateMachineMap());
        this.server = ServerImplUtils.newRaftServer(this.currentPeer.getId(), null, this.registry::get, null, this.raftProperties, this.parameters);
    }

    public void start() throws IOException {
        this.server.start();
        this.createRaftGroup(this.raftOptions.getStateMachineMap());
    }

    public void stop() throws IOException {
        this.server.close();
    }

    public void initRaftGroup(Map<HodorRaftGroup, HodorRaftStateMachine> stateMachineMap) {
        Map<RaftGroupId, HodorRaftStateMachine> machineMap = stateMachineMap.entrySet().stream().collect(Collectors.toMap(e -> ((HodorRaftGroup)e.getKey()).getRaftGroupId(), Map.Entry::getValue));
        this.registry.putAll(machineMap);
    }

    public void createRaftGroup(Map<HodorRaftGroup, HodorRaftStateMachine> stateMachineMap) throws IOException {
        for (Map.Entry<HodorRaftGroup, HodorRaftStateMachine> stateMachineEntry : stateMachineMap.entrySet()) {
            HodorRaftGroup hodorRaftGroup = stateMachineEntry.getKey();
            RaftGroup raftGroup = hodorRaftGroup.getRaftGroup();
            RaftClient raftClient = RaftUtils.createClient(hodorRaftGroup);
            Throwable throwable = null;
            try {
                try {
                    raftClient.getGroupManagementApi(this.currentPeer.getId()).add(raftGroup);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                }
                catch (IOException ioe) {
                    log.warn("Add group failed for {}", (Object)this.currentPeer, (Object)ioe);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (raftClient == null) continue;
                if (throwable != null) {
                    try {
                        raftClient.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                raftClient.close();
            }
        }
    }
}

