/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.NetUtils;
import org.dromara.hodor.common.utils.StringUtils;

public class RaftGroupManager {
    private static final RaftGroupManager INSTANCE = new RaftGroupManager();
    private final Map<String, RaftGroup> raftGroupMap = new ConcurrentHashMap<String, RaftGroup>();

    private RaftGroupManager() {
    }

    public static RaftGroupManager getInstance() {
        return INSTANCE;
    }

    public RaftGroup getRaftGroup(String groupId) {
        return this.raftGroupMap.get(groupId);
    }

    public RaftGroup createRaftGroup(RaftGroupId raftGroupId, List<String> address) {
        return this.createRaftGroup(raftGroupId.toString(), address.toArray(new String[0]));
    }

    public RaftGroup createRaftGroup(RaftGroupId raftGroupId, String[] address) {
        return this.createRaftGroup(raftGroupId.toString(), address);
    }

    public RaftGroup createRaftGroup(String groupId, String[] addresses) {
        if (StringUtils.isBlank(groupId) || groupId.length() != 16) {
            throw new IllegalArgumentException("groupId length must equals 16.");
        }
        return this.raftGroupMap.computeIfAbsent(groupId, key -> {
            ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>(addresses.length);
            for (String address : addresses) {
                String[] segmentAddress = StringUtils.split(address, ":");
                if (segmentAddress.length == 2) {
                    peers.add(this.buildRaftPeer(segmentAddress[0], Integer.parseInt(segmentAddress[1]), 0));
                }
                if (segmentAddress.length != 3) continue;
                peers.add(this.buildRaftPeer(segmentAddress[0], Integer.parseInt(segmentAddress[1]), Integer.parseInt(segmentAddress[2])));
            }
            RaftGroupId raftGroupId = RaftGroupId.valueOf(ByteString.copyFromUtf8(groupId));
            List<RaftPeer> raftPeers = Collections.unmodifiableList(peers);
            return RaftGroup.valueOf(raftGroupId, raftPeers);
        });
    }

    public void deleteRaftGroup(String groupId) {
        this.raftGroupMap.remove(groupId);
    }

    public RaftPeer buildRaftPeer(InetSocketAddress socketAddress, int priority) {
        return RaftPeer.newBuilder().setId(this.getPeerId(socketAddress)).setAddress(socketAddress).setPriority(priority).build();
    }

    public RaftPeer buildRaftPeer(String host, int port, int priority) {
        InetSocketAddress socketAddress = NetUtils.createSocketAddrForHost(host, port);
        return this.buildRaftPeer(socketAddress, priority);
    }

    private String getPeerId(InetSocketAddress address) {
        return address.getHostString() + "_" + address.getPort();
    }
}

