/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft;

import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.util.TimeDuration;
import org.dromara.hodor.common.raft.HodorRaftGroup;

public final class RaftUtils {
    private RaftUtils() {
    }

    public static void assertRaftGroupAddress(String address) {
        String[] addresses = Optional.ofNullable(address).map(s2 -> s2.split(",")).orElse(null);
        if (addresses == null || addresses.length == 0) {
            throw new IllegalArgumentException("Failed to get address: " + address);
        }
    }

    public static RaftPeerId getPeerId(InetSocketAddress address) {
        return RaftUtils.getPeerId(address.getHostString(), address.getPort());
    }

    public static RaftPeerId getPeerId(String host, int port) {
        return RaftPeerId.getRaftPeerId(host + "_" + port);
    }

    public static RaftClient createClient(HodorRaftGroup hodorRaftGroup) {
        RaftProperties properties = hodorRaftGroup.getRaftProperties();
        RaftClientConfigKeys.Rpc.setRequestTimeout(properties, TimeDuration.valueOf(15L, TimeUnit.SECONDS));
        ExponentialBackoffRetry retryPolicy = ExponentialBackoffRetry.newBuilder().setBaseSleepTime(TimeDuration.valueOf(1000L, TimeUnit.MILLISECONDS)).setMaxAttempts(10).setMaxSleepTime(TimeDuration.valueOf(100000L, TimeUnit.MILLISECONDS)).build();
        return RaftClient.newBuilder().setRaftGroup(hodorRaftGroup.getRaftGroup()).setProperties(properties).setRetryPolicy(retryPolicy).build();
    }
}

