/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.core;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.ratis.client.RaftClient;
import org.dromara.hodor.common.raft.HodorRaftGroup;
import org.dromara.hodor.common.raft.RaftUtils;
import org.dromara.hodor.common.raft.kv.core.HodorKVOperator;
import org.dromara.hodor.common.raft.kv.core.KVOperator;
import org.dromara.hodor.common.raft.kv.storage.DBColumnFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HodorKVClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HodorKVClient.class);
    private final RaftClient raftClient;
    private final Map<String, KVOperator> tableNameMap;
    private final String clientId;

    public HodorKVClient(HodorRaftGroup hodorRaftGroup) {
        this.raftClient = RaftUtils.createClient(hodorRaftGroup);
        this.tableNameMap = new HashMap<String, KVOperator>();
        this.clientId = hodorRaftGroup.getRaftProperties().get("hodor.client.id");
    }

    public KVOperator kvOperator(String tableName) {
        return this.tableNameMap.computeIfAbsent(tableName, k -> new HodorKVOperator(this.clientId, tableName, this.raftClient));
    }

    public KVOperator defaultKvOperator() {
        return this.kvOperator(DBColumnFamily.Default.getName());
    }

    public RaftClient getRaftClient() {
        return this.raftClient;
    }

    @Override
    public void close() throws Exception {
        this.raftClient.close();
        this.tableNameMap.clear();
    }
}

