/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.core;

import java.io.IOException;
import java.util.List;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.dromara.hodor.common.raft.kv.core.KVOperator;
import org.dromara.hodor.common.raft.kv.exception.HodorKVClientException;
import org.dromara.hodor.common.raft.kv.exception.HodorKVConnectException;
import org.dromara.hodor.common.raft.kv.protocol.CmdType;
import org.dromara.hodor.common.raft.kv.protocol.ContainsKeyRequest;
import org.dromara.hodor.common.raft.kv.protocol.DeleteRequest;
import org.dromara.hodor.common.raft.kv.protocol.GetRequest;
import org.dromara.hodor.common.raft.kv.protocol.HodorKVRequest;
import org.dromara.hodor.common.raft.kv.protocol.HodorKVResponse;
import org.dromara.hodor.common.raft.kv.protocol.KVEntry;
import org.dromara.hodor.common.raft.kv.protocol.PutRequest;
import org.dromara.hodor.common.raft.kv.protocol.ScanRequest;
import org.dromara.hodor.common.utils.ProtostuffUtils;

public class HodorKVOperator
implements KVOperator {
    private final String clientId;
    private final String tableName;
    private final RaftClient raftClient;

    HodorKVOperator(String clientId, String tableName, RaftClient raftClient) {
        this.clientId = clientId;
        this.tableName = tableName;
        this.raftClient = raftClient;
    }

    @Override
    public byte[] get(byte[] key) {
        GetRequest getRequest = GetRequest.builder().key(key).build();
        HodorKVRequest request = HodorKVRequest.builder().table(this.tableName).cmdType(CmdType.GET).getRequest(getRequest).build();
        HodorKVResponse response = this.handleReadRequest(request);
        if (response.getSuccess().booleanValue()) {
            return response.getGetResponse().getValue();
        }
        throw new HodorKVClientException(response.getMessage());
    }

    @Override
    public void put(byte[] key, byte[] value) {
        PutRequest putRequest = PutRequest.builder().key(key).value(value).build();
        HodorKVRequest request = HodorKVRequest.builder().table(this.tableName).cmdType(CmdType.PUT).putRequest(putRequest).build();
        HodorKVResponse response = this.handleWriteRequest(request);
        if (!response.getSuccess().booleanValue()) {
            throw new HodorKVClientException(response.getMessage());
        }
    }

    @Override
    public void putEphemeral(byte[] key, byte[] value) {
        PutRequest putRequest = PutRequest.builder().key(key).value(value).build();
        HodorKVRequest request = HodorKVRequest.builder().table(this.tableName).sessionId(this.clientId).cmdType(CmdType.PUT).putRequest(putRequest).build();
        HodorKVResponse response = this.handleWriteRequest(request);
        if (!response.getSuccess().booleanValue()) {
            throw new HodorKVClientException(response.getMessage());
        }
    }

    @Override
    public void delete(byte[] key) {
        DeleteRequest deleteRequest = DeleteRequest.builder().key(key).build();
        HodorKVRequest request = HodorKVRequest.builder().table(this.tableName).cmdType(CmdType.DELETE).deleteRequest(deleteRequest).build();
        HodorKVResponse response = this.handleWriteRequest(request);
        if (!response.getSuccess().booleanValue()) {
            throw new HodorKVClientException(response.getMessage());
        }
    }

    @Override
    public Boolean containsKey(byte[] key) {
        ContainsKeyRequest containsKeyRequest = ContainsKeyRequest.builder().key(key).build();
        HodorKVRequest request = HodorKVRequest.builder().table(this.tableName).cmdType(CmdType.CONTAINS_KEY).containsKeyRequest(containsKeyRequest).build();
        HodorKVResponse response = this.handleReadRequest(request);
        if (!response.getSuccess().booleanValue()) {
            throw new HodorKVClientException(response.getMessage());
        }
        return response.getContainsKeyResponse().getValue();
    }

    @Override
    public List<KVEntry> scan(byte[] startKey, byte[] endKey, boolean returnValue) {
        ScanRequest scanRequest = ScanRequest.builder().startKey(startKey).endKey(endKey).build();
        HodorKVRequest request = HodorKVRequest.builder().table(this.tableName).cmdType(CmdType.SCAN).scanRequest(scanRequest).build();
        HodorKVResponse response = this.handleReadRequest(request);
        if (!response.getSuccess().booleanValue()) {
            throw new HodorKVClientException(response.getMessage());
        }
        return response.getScanResponse().getValue();
    }

    @Override
    public void close() throws IOException {
        this.raftClient.close();
    }

    private HodorKVResponse handleReadRequest(HodorKVRequest request) {
        try {
            byte[] bytes = ProtostuffUtils.serialize(request);
            RaftClientReply raftClientReply = this.raftClient.io().sendReadOnly(Message.valueOf(ByteString.copyFrom(bytes)));
            return ProtostuffUtils.deserialize(raftClientReply.getMessage().getContent().toByteArray(), HodorKVResponse.class);
        }
        catch (Exception e) {
            throw new HodorKVConnectException(e.getMessage(), e);
        }
    }

    private HodorKVResponse handleWriteRequest(HodorKVRequest request) {
        try {
            byte[] bytes = ProtostuffUtils.serialize(request);
            RaftClientReply raftClientReply = this.raftClient.io().send(Message.valueOf(ByteString.copyFrom(bytes)));
            return ProtostuffUtils.deserialize(raftClientReply.getMessage().getContent().toByteArray(), HodorKVResponse.class);
        }
        catch (Exception e) {
            throw new HodorKVConnectException(e.getMessage(), e);
        }
    }
}

