/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.core;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dromara.hodor.common.raft.kv.core.RequestHandler;
import org.dromara.hodor.common.raft.kv.exception.HodorKVException;
import org.dromara.hodor.common.raft.kv.protocol.CmdType;
import org.dromara.hodor.common.raft.kv.protocol.ContainsKeyRequest;
import org.dromara.hodor.common.raft.kv.protocol.ContainsKeyResponse;
import org.dromara.hodor.common.raft.kv.protocol.DeleteRequest;
import org.dromara.hodor.common.raft.kv.protocol.GetRequest;
import org.dromara.hodor.common.raft.kv.protocol.GetResponse;
import org.dromara.hodor.common.raft.kv.protocol.HodorKVRequest;
import org.dromara.hodor.common.raft.kv.protocol.HodorKVResponse;
import org.dromara.hodor.common.raft.kv.protocol.KVEntry;
import org.dromara.hodor.common.raft.kv.protocol.PutRequest;
import org.dromara.hodor.common.raft.kv.protocol.ScanRequest;
import org.dromara.hodor.common.raft.kv.protocol.ScanResponse;
import org.dromara.hodor.common.raft.kv.storage.DBStore;
import org.dromara.hodor.common.raft.kv.storage.StorageEngine;
import org.dromara.hodor.common.raft.kv.storage.Table;
import org.dromara.hodor.common.utils.BytesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HodorKVRequestHandler
implements RequestHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HodorKVRequestHandler.class);
    private final DBStore dbStore;

    public HodorKVRequestHandler(StorageEngine storageEngine) {
        this.dbStore = storageEngine.getRawDBStore();
    }

    @Override
    public void validateRequest(HodorKVRequest request) throws HodorKVException {
        CmdType cmdType = request.getCmdType();
        if (cmdType == null) {
            throw new HodorKVException("CmdType is null", HodorKVException.ResultCodes.INVALID_REQUEST);
        }
    }

    @Override
    public HodorKVResponse handleReadRequest(HodorKVRequest kvRequest) throws IOException {
        CmdType cmdType = kvRequest.getCmdType();
        Table<byte[], byte[]> table = this.dbStore.getTable(kvRequest.getTable());
        HodorKVResponse.HodorKVResponseBuilder builder = HodorKVRequestHandler.createHodorKVResponseBuilder(kvRequest, cmdType);
        switch (cmdType) {
            case GET: {
                try {
                    GetRequest getRequest = kvRequest.getGetRequest();
                    byte[] result = table.get(getRequest.getKey());
                    GetResponse getResponse = GetResponse.builder().value(result).build();
                    builder.getResponse(getResponse);
                }
                catch (Exception e) {
                    log.error("GET exception: {}", (Object)e.getMessage(), (Object)e);
                    builder.success(false).message(e.getMessage());
                }
                break;
            }
            case CONTAINS_KEY: {
                ContainsKeyRequest containsKeyRequest = kvRequest.getContainsKeyRequest();
                try {
                    Boolean exists = table.containsKey(containsKeyRequest.getKey());
                    ContainsKeyResponse containsKeyResponse = ContainsKeyResponse.builder().value(exists).build();
                    builder.containsKeyResponse(containsKeyResponse);
                }
                catch (Exception e) {
                    log.error("CONTAINS_KEY exception: key: [{}], {}.", BytesUtil.toHex(containsKeyRequest.getKey()), e.getMessage(), e);
                    builder.success(false).message(e.getMessage());
                }
                break;
            }
            case SCAN: {
                ScanRequest scanRequest = kvRequest.getScanRequest();
                byte[] startKey = scanRequest.getStartKey();
                byte[] endKey = scanRequest.getEndKey();
                try {
                    List<KVEntry> kvEntries = table.scan(startKey, endKey, scanRequest.isReturnValue());
                    ScanResponse scanResponse = ScanResponse.builder().value(kvEntries).build();
                    builder.scanResponse(scanResponse);
                }
                catch (Exception e) {
                    log.error("Fail to [SCAN], range: ['[{}, {})'], {}.", BytesUtil.toHex(startKey), BytesUtil.toHex(endKey), ExceptionUtils.getStackTrace(e));
                    builder.success(false).message(e.getMessage());
                }
                break;
            }
            default: {
                throw new RuntimeException("Unsupported query request type: " + (Object)((Object)cmdType));
            }
        }
        return builder.build();
    }

    @Override
    public HodorKVResponse handleWriteRequest(HodorKVRequest kvRequest, long transactionLogIndex) throws IOException {
        CmdType cmdType = kvRequest.getCmdType();
        Table<byte[], byte[]> table = this.dbStore.getTable(kvRequest.getTable());
        HodorKVResponse.HodorKVResponseBuilder builder = HodorKVRequestHandler.createHodorKVResponseBuilder(kvRequest, cmdType);
        switch (cmdType) {
            case PUT: {
                PutRequest putRequest = kvRequest.getPutRequest();
                try {
                    table.put(putRequest.getKey(), putRequest.getValue());
                }
                catch (Exception e) {
                    log.error("PUT exception: {}", (Object)e.getMessage(), (Object)e);
                    builder.success(false).message(e.getMessage());
                }
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = kvRequest.getDeleteRequest();
                try {
                    table.delete(deleteRequest.getKey());
                }
                catch (Exception e) {
                    log.error("DELETE exception: {}", (Object)e.getMessage(), (Object)e);
                    builder.success(false).message(e.getMessage());
                }
                break;
            }
            default: {
                throw new RuntimeException("Unsupported write request type: " + (Object)((Object)cmdType));
            }
        }
        return builder.build();
    }

    public static HodorKVResponse.HodorKVResponseBuilder createHodorKVResponseBuilder(HodorKVRequest kvRequest, CmdType cmdType) {
        return HodorKVResponse.builder().requestId(kvRequest.getRequestId()).traceId(kvRequest.getTraceId()).cmdType(cmdType).success(true);
    }
}

