/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.core;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.util.NetUtils;
import org.dromara.hodor.common.HodorLifecycle;
import org.dromara.hodor.common.raft.HodorRaftGroup;
import org.dromara.hodor.common.raft.HodorRaftServer;
import org.dromara.hodor.common.raft.HodorRaftStateMachine;
import org.dromara.hodor.common.raft.RaftGroupManager;
import org.dromara.hodor.common.raft.RaftOptions;
import org.dromara.hodor.common.raft.kv.core.HodorKVOptions;
import org.dromara.hodor.common.raft.kv.core.HodorKVRequestHandler;
import org.dromara.hodor.common.raft.kv.core.HodorKVSnapshotInfo;
import org.dromara.hodor.common.raft.kv.core.HodorKVStateMachine;
import org.dromara.hodor.common.raft.kv.core.HodorKvManager;
import org.dromara.hodor.common.raft.kv.storage.StorageEngine;
import org.dromara.hodor.common.raft.kv.storage.StorageOptions;
import org.dromara.hodor.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HodorKVServer
implements HodorLifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HodorKVServer.class);
    private HodorRaftServer hodorRaftServer;
    public final StorageEngine storageEngine;
    private final HodorKVOptions hodorKVOptions;

    public HodorKVServer(HodorKVOptions hodorKVOptions) throws Exception {
        Utils.Assert.notNull(hodorKVOptions, "hodorRaftServer must be not null.", new Object[0]);
        this.hodorKVOptions = hodorKVOptions;
        StorageOptions storageOptions = hodorKVOptions.getStorageOptions();
        RaftOptions raftOptions = hodorKVOptions.getRaftOptions();
        RaftPeer raftPeer = RaftGroupManager.getInstance().buildRaftPeer(NetUtils.createSocketAddr(raftOptions.getEndpoint()), 0);
        storageOptions.setStoragePath(new File(storageOptions.getStoragePath(), Paths.get(hodorKVOptions.getClusterName(), raftPeer.getId().toString(), storageOptions.getStorageType().getName()).toString()));
        this.storageEngine = new StorageEngine(storageOptions);
        this.storageEngine.init();
    }

    @Override
    public void start() throws Exception {
        Map<HodorRaftGroup, HodorRaftStateMachine> stateMachineMap;
        RaftOptions raftOptions = this.hodorKVOptions.getRaftOptions();
        Optional<RaftProperties> raftPropertiesOptional = Optional.ofNullable(raftOptions.getRaftProperties());
        Optional<Map<HodorRaftGroup, HodorRaftStateMachine>> stateMachineMapOptional = Optional.ofNullable(raftOptions.getStateMachineMap());
        if (stateMachineMapOptional.isPresent()) {
            stateMachineMap = stateMachineMapOptional.get();
        } else {
            HashMap<HodorRaftGroup, HodorRaftStateMachine> stateMachineHashMap = new HashMap<HodorRaftGroup, HodorRaftStateMachine>();
            HodorRaftGroup hodorRaftGroup = HodorRaftGroup.builder().raftGroupName("HodorKVGroup0000").addresses(raftOptions.getServerAddresses()).build();
            HodorKVRequestHandler requestHandler = new HodorKVRequestHandler(this.storageEngine);
            HodorKVSnapshotInfo snapshotInfo = new HodorKVSnapshotInfo();
            HodorKvManager dbStoreHAManager = new HodorKvManager(this.storageEngine);
            stateMachineHashMap.putIfAbsent(hodorRaftGroup, new HodorKVStateMachine(requestHandler, snapshotInfo, dbStoreHAManager));
            stateMachineMap = stateMachineHashMap;
        }
        raftOptions.setStorageDir(new File(raftOptions.getStorageDir(), this.hodorKVOptions.getClusterName()));
        raftOptions.setStateMachineMap(stateMachineMap);
        raftOptions.setRaftProperties(raftPropertiesOptional.orElseGet(RaftProperties::new));
        this.hodorRaftServer = new HodorRaftServer(raftOptions);
        this.hodorRaftServer.start();
    }

    @Override
    public void stop() throws Exception {
        this.hodorRaftServer.stop();
        this.storageEngine.close();
    }
}

