/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.core;

import java.util.List;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HodorKVSnapshotInfo
implements SnapshotInfo {
    private static final Logger LOG = LoggerFactory.getLogger(HodorKVSnapshotInfo.class);
    private volatile long term = 0L;
    private volatile long snapshotIndex = -1L;

    public void updateTerm(long newTerm) {
        this.term = newTerm;
    }

    public void updateTermIndex(long newTerm, long newIndex) {
        this.term = newTerm;
        this.snapshotIndex = newIndex;
    }

    public HodorKVSnapshotInfo() {
    }

    public HodorKVSnapshotInfo(long term, long index) {
        this.term = term;
        this.snapshotIndex = index;
    }

    @Override
    public TermIndex getTermIndex() {
        return TermIndex.valueOf(this.term, this.snapshotIndex);
    }

    @Override
    public long getTerm() {
        return this.term;
    }

    @Override
    public long getIndex() {
        return this.snapshotIndex;
    }

    @Override
    public List<FileInfo> getFiles() {
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.term);
        stringBuilder.append("#");
        stringBuilder.append(this.snapshotIndex);
        return stringBuilder.toString();
    }
}

