/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.core;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.netty.handler.codec.CodecException;
import org.apache.ratis.util.LifeCycle;
import org.dromara.hodor.common.raft.HodorRaftStateMachine;
import org.dromara.hodor.common.raft.kv.core.DBStoreHAManager;
import org.dromara.hodor.common.raft.kv.core.HodorKVSnapshotInfo;
import org.dromara.hodor.common.raft.kv.core.RequestHandler;
import org.dromara.hodor.common.raft.kv.core.TransactionInfo;
import org.dromara.hodor.common.raft.kv.protocol.HodorKVRequest;
import org.dromara.hodor.common.raft.kv.protocol.HodorKVResponse;
import org.dromara.hodor.common.raft.kv.storage.Table;
import org.dromara.hodor.common.utils.BytesUtil;
import org.dromara.hodor.common.utils.ProtostuffUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HodorKVStateMachine
extends HodorRaftStateMachine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HodorKVStateMachine.class);
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private RaftGroupId raftGroupId;
    private final RequestHandler requestHandler;
    private final HodorKVSnapshotInfo snapshotInfo;
    private final DBStoreHAManager dbStoreHAManager;

    public HodorKVStateMachine(RequestHandler requestHandler, HodorKVSnapshotInfo snapshotInfo, DBStoreHAManager dbStoreHAManager) throws IOException {
        this.requestHandler = requestHandler;
        this.snapshotInfo = snapshotInfo;
        this.dbStoreHAManager = dbStoreHAManager;
        this.loadSnapshotInfoFromDB();
    }

    @Override
    public void initialize(RaftServer raftServer, RaftGroupId id, RaftStorage raftStorage) throws IOException {
        this.getLifeCycle().startAndTransition(() -> {
            super.initialize(raftServer, this.raftGroupId, raftStorage);
            this.raftGroupId = id;
            this.storage.init(raftStorage);
        }, new Class[0]);
    }

    @Override
    public void reinitialize() throws IOException {
        if (this.getLifeCycleState() == LifeCycle.State.PAUSED) {
            this.getLifeCycle().startAndTransition(() -> {
                this.loadSnapshotInfoFromDB();
                this.setLastAppliedTermIndex(this.getLastAppliedTermIndex());
            }, new Class[0]);
        }
    }

    @Override
    public SnapshotInfo getLatestSnapshot() {
        LOG.debug("Latest Snapshot Info {}", (Object)this.snapshotInfo);
        return this.snapshotInfo;
    }

    @Override
    public long takeSnapshot() throws IOException {
        TermIndex lastTermIndex = this.getLastAppliedTermIndex();
        if (lastTermIndex == null || lastTermIndex.getIndex() == -1L) {
            return -1L;
        }
        long lastAppliedIndex = lastTermIndex.getIndex();
        this.snapshotInfo.updateTermIndex(lastTermIndex.getTerm(), lastAppliedIndex);
        TransactionInfo build = new TransactionInfo.Builder().setTransactionIndex(lastAppliedIndex).setCurrentTerm(lastTermIndex.getTerm()).build();
        Table<byte[], byte[]> txnInfoTable = this.dbStoreHAManager.getTransactionInfoTable();
        txnInfoTable.put(BytesUtil.writeUtf8("#TRANSACTIONINFO"), ProtostuffUtils.serialize(build));
        this.dbStoreHAManager.flushDB();
        return lastTermIndex.getIndex();
    }

    @Override
    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    public void loadSnapshotInfoFromDB() throws IOException {
        TransactionInfo transactionInfo = TransactionInfo.readTransactionInfo(this.dbStoreHAManager);
        if (transactionInfo != null) {
            this.setLastAppliedTermIndex(TermIndex.valueOf(transactionInfo.getTerm(), transactionInfo.getTransactionIndex()));
            this.snapshotInfo.updateTermIndex(transactionInfo.getTerm(), transactionInfo.getTransactionIndex());
        }
        LOG.info("LastAppliedIndex is set from TransactionInfo from OM DB as {}", (Object)this.getLastAppliedTermIndex());
    }

    @Override
    public CompletableFuture<TermIndex> notifyInstallSnapshotFromLeader(RaftProtos.RoleInfoProto roleInfoProto, TermIndex firstTermIndexInLog) {
        String leaderNodeId = RaftPeerId.valueOf(roleInfoProto.getFollowerInfo().getLeaderInfo().getId().getId()).toString();
        LOG.info("Received install snapshot notification from OM leader: {} with term index: {}", (Object)leaderNodeId, (Object)firstTermIndexInLog);
        return super.notifyInstallSnapshotFromLeader(roleInfoProto, firstTermIndexInLog);
    }

    @Override
    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        try {
            ByteString logData = trx.getStateMachineLogEntry().getLogData();
            Message message = Message.valueOf(logData);
            TermIndex termIndex = TermIndex.valueOf(trx.getLogEntry());
            HodorKVRequest kvRequest = ProtostuffUtils.deserialize(message.getContent().toByteArray(), HodorKVRequest.class);
            return CompletableFuture.completedFuture(this.runCommand(kvRequest, termIndex));
        }
        catch (Exception e) {
            return HodorKVStateMachine.completeExceptionally(e);
        }
    }

    @Override
    public CompletableFuture<Message> query(Message request) {
        try {
            HodorKVRequest kvRequest = ProtostuffUtils.deserialize(request.getContent().toByteArray(), HodorKVRequest.class);
            return CompletableFuture.completedFuture(this.runQueryCommand(kvRequest));
        }
        catch (Exception e) {
            return HodorKVStateMachine.completeExceptionally(e);
        }
    }

    private Message runQueryCommand(HodorKVRequest kvRequest) throws IOException {
        HodorKVResponse hodorKVResponse = this.requestHandler.handleReadRequest(kvRequest);
        return Message.valueOf(ByteString.copyFrom(ProtostuffUtils.serialize(hodorKVResponse)));
    }

    private Message runCommand(HodorKVRequest kvRequest, TermIndex termIndex) throws CodecException, IOException {
        long term = termIndex.getTerm();
        long trxLogIndex = termIndex.getIndex();
        HodorKVResponse hodorKVResponse = this.requestHandler.handleWriteRequest(kvRequest, trxLogIndex);
        this.updateLastAppliedTermIndex(termIndex);
        return Message.valueOf(ByteString.copyFrom(ProtostuffUtils.serialize(hodorKVResponse)));
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private static <T> CompletableFuture<T> completeExceptionally(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }
}

