/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.core;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.dromara.com.google.common.base.Preconditions;
import org.dromara.hodor.common.raft.kv.core.DBStoreHAManager;
import org.dromara.hodor.common.raft.kv.core.HodorKVSnapshotInfo;
import org.dromara.hodor.common.utils.BytesUtil;
import org.dromara.hodor.common.utils.ProtostuffUtils;
import org.dromara.hodor.common.utils.StringUtils;

public final class TransactionInfo {
    private long term;
    private long transactionIndex;

    private TransactionInfo(String transactionInfo) {
        String[] tInfo = transactionInfo.split("#");
        Preconditions.checkState(tInfo.length == 2, "Incorrect TransactionInfo value");
        this.term = Long.parseLong(tInfo[0]);
        this.transactionIndex = Long.parseLong(tInfo[1]);
    }

    private TransactionInfo(long currentTerm, long transactionIndex) {
        this.term = currentTerm;
        this.transactionIndex = transactionIndex;
    }

    public boolean isDefault() {
        return this.transactionIndex == -1L && this.term == 0L;
    }

    public int compareTo(TransactionInfo info) {
        if (info.getTerm() == this.getTerm()) {
            return (int)(this.getTransactionIndex() - info.getTransactionIndex());
        }
        return (int)(this.getTerm() - info.getTerm());
    }

    public long getTerm() {
        return this.term;
    }

    public long getTransactionIndex() {
        return this.transactionIndex;
    }

    public TermIndex getTermIndex() {
        return TermIndex.valueOf(this.term, this.transactionIndex);
    }

    private String generateTransactionInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.term);
        stringBuilder.append("#");
        stringBuilder.append(this.transactionIndex);
        return stringBuilder.toString();
    }

    public byte[] convertToByteArray() {
        return StringUtils.string2Bytes(this.generateTransactionInfo());
    }

    public static TransactionInfo getFromByteArray(byte[] bytes) {
        String tInfo = StringUtils.bytes2String(bytes);
        return new TransactionInfo(tInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInfo that = (TransactionInfo)o;
        return this.term == that.term && this.transactionIndex == that.transactionIndex;
    }

    public static TransactionInfo fromTermIndex(TermIndex termIndex) {
        return new Builder().setCurrentTerm(termIndex.getTerm()).setTransactionIndex(termIndex.getIndex()).build();
    }

    public int hashCode() {
        return Objects.hash(this.term, this.transactionIndex);
    }

    public String toString() {
        return this.generateTransactionInfo();
    }

    public static TransactionInfo readTransactionInfo(DBStoreHAManager metadataManager) throws IOException {
        byte[] bytes = metadataManager.getTransactionInfoTable().get(BytesUtil.writeUtf8("#TRANSACTIONINFO"));
        if (bytes == null) {
            return null;
        }
        return ProtostuffUtils.deserialize(bytes, TransactionInfo.class);
    }

    public SnapshotInfo toSnapshotInfo() {
        return new HodorKVSnapshotInfo(this.term, this.transactionIndex);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long currentTerm = 0L;
        private long transactionIndex = -1L;

        public Builder setCurrentTerm(long term) {
            this.currentTerm = term;
            return this;
        }

        public Builder setTransactionIndex(long tIndex) {
            this.transactionIndex = tIndex;
            return this;
        }

        public TransactionInfo build() {
            return new TransactionInfo(this.currentTerm, this.transactionIndex);
        }
    }
}

