/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import org.dromara.hodor.common.utils.BytesUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.RocksDB;

public enum DBColumnFamily {
    Default{
        final String name = "default";

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public ColumnFamilyDescriptor getColumnFamilyDescriptor(ColumnFamilyOptions cfOptions) {
            return new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cfOptions);
        }
    }
    ,
    HodorRaft{
        final String name = "hodor_raft";

        @Override
        public String getName() {
            return "hodor_raft";
        }

        @Override
        public ColumnFamilyDescriptor getColumnFamilyDescriptor(ColumnFamilyOptions cfOptions) {
            return new ColumnFamilyDescriptor(BytesUtil.writeUtf8("hodor_raft"), cfOptions);
        }
    }
    ,
    HodorWatch{
        final String name = "hodor_watch";

        @Override
        public String getName() {
            return "hodor_watch";
        }

        @Override
        public ColumnFamilyDescriptor getColumnFamilyDescriptor(ColumnFamilyOptions cfOptions) {
            return new ColumnFamilyDescriptor(BytesUtil.writeUtf8("hodor_watch"), cfOptions);
        }
    }
    ,
    HodorLock{
        final String name = "hodor_lock";

        @Override
        public String getName() {
            return "hodor_lock";
        }

        @Override
        public ColumnFamilyDescriptor getColumnFamilyDescriptor(ColumnFamilyOptions cfOptions) {
            return new ColumnFamilyDescriptor(BytesUtil.writeUtf8("hodor_lock"), cfOptions);
        }
    }
    ,
    HodorSeq{
        final String name = "hodor_seq";

        @Override
        public String getName() {
            return "hodor_seq";
        }

        @Override
        public ColumnFamilyDescriptor getColumnFamilyDescriptor(ColumnFamilyOptions cfOptions) {
            return new ColumnFamilyDescriptor(BytesUtil.writeUtf8("hodor_seq"), cfOptions);
        }
    }
    ,
    HodorWrite{
        final String name = "hodor_write";

        @Override
        public String getName() {
            return "hodor_write";
        }

        @Override
        public ColumnFamilyDescriptor getColumnFamilyDescriptor(ColumnFamilyOptions cfOptions) {
            return new ColumnFamilyDescriptor(BytesUtil.writeUtf8("hodor_write"), cfOptions);
        }
    };


    public abstract String getName();

    public abstract ColumnFamilyDescriptor getColumnFamilyDescriptor(ColumnFamilyOptions var1);
}

