/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.dromara.com.google.common.base.Preconditions;
import org.dromara.hodor.common.raft.kv.exception.ExceptionHelper;
import org.dromara.hodor.common.utils.StringUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.OptionsUtil;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBConfigFromFile {
    private static final Logger LOG = LoggerFactory.getLogger(DBConfigFromFile.class);
    public static final String CONFIG_DIR = "OZONE_CONF_DIR";

    private DBConfigFromFile() {
    }

    public static File getConfigLocation() throws IOException {
        String path = System.getenv(CONFIG_DIR);
        if (StringUtils.isBlank(path)) {
            path = System.getProperty(CONFIG_DIR);
        }
        if (StringUtils.isBlank(path)) {
            LOG.debug("Unable to find the configuration directory. Please make sure that OZONE_CONF_DIR is setup correctly.");
            return null;
        }
        return new File(path);
    }

    public static String getOptionsFileNameFromDB(String dbFileName) {
        Preconditions.checkNotNull(dbFileName);
        return dbFileName + ".ini";
    }

    public static DBOptions readFromFile(String dbFileName, List<ColumnFamilyDescriptor> cfDescs) throws IOException {
        Path optionsFile;
        Preconditions.checkNotNull(dbFileName);
        Preconditions.checkNotNull(cfDescs);
        Preconditions.checkArgument(cfDescs.size() > 0);
        Env env = Env.getDefault();
        DBOptions options = null;
        File configLocation = DBConfigFromFile.getConfigLocation();
        if (configLocation != null && StringUtils.isNotBlank(configLocation.toString()) && (optionsFile = Paths.get(configLocation.toString(), DBConfigFromFile.getOptionsFileNameFromDB(dbFileName))).toFile().exists()) {
            options = new DBOptions();
            try {
                OptionsUtil.loadOptionsFromFile(optionsFile.toString(), env, options, cfDescs, true);
            }
            catch (RocksDBException rdEx) {
                ExceptionHelper.toIOException("Unable to find/open Options file.", rdEx);
            }
        }
        return options;
    }
}

