/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import java.math.BigDecimal;
import org.dromara.hodor.common.utils.StorageUnit;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.DBOptions;
import org.rocksdb.LRUCache;

public enum DBProfile {
    SSD{

        public String toString() {
            return "SSD";
        }

        @Override
        public ColumnFamilyOptions getColumnFamilyOptions() {
            long writeBufferSize = DBProfile.toLong(StorageUnit.MB.toBytes(128.0));
            return new ColumnFamilyOptions().setLevelCompactionDynamicLevelBytes(true).setWriteBufferSize(writeBufferSize).setTableFormatConfig(this.getBlockBasedTableConfig());
        }

        @Override
        public DBOptions getDBOptions() {
            int maxBackgroundCompactions = 4;
            long bytesPerSync = DBProfile.toLong(StorageUnit.MB.toBytes(1.0));
            boolean createIfMissing = true;
            boolean createMissingColumnFamilies = true;
            return new DBOptions().setIncreaseParallelism(Runtime.getRuntime().availableProcessors()).setMaxBackgroundJobs(4).setBytesPerSync(bytesPerSync).setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
        }

        @Override
        public BlockBasedTableConfig getBlockBasedTableConfig() {
            long blockCacheSize = DBProfile.toLong(StorageUnit.MB.toBytes(256.0));
            long blockSize = DBProfile.toLong(StorageUnit.KB.toBytes(16.0));
            return new BlockBasedTableConfig().setBlockCache(new LRUCache(blockCacheSize)).setBlockSize(blockSize).setPinL0FilterAndIndexBlocksInCache(true).setFilterPolicy(new BloomFilter());
        }
    }
    ,
    DISK{

        public String toString() {
            return "DISK";
        }

        @Override
        public DBOptions getDBOptions() {
            long readAheadSize = DBProfile.toLong(StorageUnit.MB.toBytes(4.0));
            return SSD.getDBOptions().setCompactionReadaheadSize(readAheadSize);
        }

        @Override
        public ColumnFamilyOptions getColumnFamilyOptions() {
            ColumnFamilyOptions columnFamilyOptions = SSD.getColumnFamilyOptions();
            columnFamilyOptions.setCompactionStyle(CompactionStyle.LEVEL);
            return columnFamilyOptions;
        }

        @Override
        public BlockBasedTableConfig getBlockBasedTableConfig() {
            return SSD.getBlockBasedTableConfig();
        }
    };


    private static long toLong(double value) {
        BigDecimal temp = BigDecimal.valueOf(value);
        return temp.longValue();
    }

    public abstract DBOptions getDBOptions();

    public abstract ColumnFamilyOptions getColumnFamilyOptions();

    public abstract BlockBasedTableConfig getBlockBasedTableConfig();
}

