/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.hodor.common.raft.kv.storage.ByteArrayKeyValue;
import org.dromara.hodor.common.raft.kv.storage.RocksDBTable;
import org.dromara.hodor.common.raft.kv.storage.TableIterator;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBStoreIterator
implements TableIterator<byte[], ByteArrayKeyValue> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RDBStoreIterator.class);
    private final RocksIterator rocksDBIterator;
    private RocksDBTable rocksDBTable;
    private ByteArrayKeyValue currentEntry;

    public RDBStoreIterator(RocksIterator iterator) {
        this.rocksDBIterator = iterator;
        this.seekToFirst();
    }

    public RDBStoreIterator(RocksIterator iterator, RocksDBTable table) {
        this(iterator);
        this.rocksDBTable = table;
    }

    @Override
    public void forEachRemaining(Consumer<? super ByteArrayKeyValue> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    private void setCurrentEntry() {
        this.currentEntry = this.rocksDBIterator.isValid() ? ByteArrayKeyValue.create(this.rocksDBIterator.key(), this.rocksDBIterator.value()) : null;
    }

    @Override
    public boolean hasNext() {
        return this.rocksDBIterator.isValid();
    }

    @Override
    public ByteArrayKeyValue next() {
        this.setCurrentEntry();
        if (this.currentEntry != null) {
            this.rocksDBIterator.next();
            return this.currentEntry;
        }
        throw new NoSuchElementException("RocksDB Store has no more elements");
    }

    @Override
    public void seekToFirst() {
        this.rocksDBIterator.seekToFirst();
        this.setCurrentEntry();
    }

    @Override
    public void seekToLast() {
        this.rocksDBIterator.seekToLast();
        this.setCurrentEntry();
    }

    @Override
    public ByteArrayKeyValue seek(byte[] key) {
        this.rocksDBIterator.seek(key);
        this.setCurrentEntry();
        return this.currentEntry;
    }

    @Override
    public void removeFromDB() throws IOException {
        if (this.rocksDBTable == null) {
            throw new UnsupportedOperationException("remove");
        }
        if (this.currentEntry != null) {
            this.rocksDBTable.delete(this.currentEntry.getKey());
        } else {
            log.info("Unable to delete currentEntry as it does not exist.");
        }
    }

    @Override
    public void close() throws IOException {
        this.rocksDBIterator.close();
    }
}

