/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import java.io.IOException;
import org.dromara.hodor.common.raft.kv.storage.BatchOperation;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBBatchOperation
implements BatchOperation {
    private final WriteBatch writeBatch;

    public RocksDBBatchOperation() {
        this.writeBatch = new WriteBatch();
    }

    public RocksDBBatchOperation(WriteBatch writeBatch) {
        this.writeBatch = writeBatch;
    }

    public void commit(RocksDB db, WriteOptions writeOptions) throws IOException {
        try {
            db.write(writeOptions, this.writeBatch);
        }
        catch (RocksDBException e) {
            throw new IOException("Unable to write the batch.", e);
        }
    }

    @Override
    public void close() {
        this.writeBatch.close();
    }

    public void delete(ColumnFamilyHandle handle, byte[] key) throws IOException {
        try {
            this.writeBatch.delete(handle, key);
        }
        catch (RocksDBException e) {
            throw new IOException("Can't record batch delete operation.", e);
        }
    }

    public void put(ColumnFamilyHandle handle, byte[] key, byte[] value) throws IOException {
        try {
            this.writeBatch.put(handle, key, value);
        }
        catch (RocksDBException e) {
            throw new IOException("Can't record batch put operation.", e);
        }
    }
}

