/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.dromara.hodor.common.raft.kv.exception.ExceptionHelper;
import org.dromara.hodor.common.raft.kv.exception.StorageDBException;
import org.dromara.hodor.common.raft.kv.storage.DBColumnFamily;
import org.dromara.hodor.common.raft.kv.storage.DBStore;
import org.dromara.hodor.common.raft.kv.storage.RocksDBTable;
import org.dromara.hodor.common.raft.kv.storage.StorageOptions;
import org.dromara.hodor.common.raft.kv.storage.Table;
import org.dromara.hodor.common.utils.BytesUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStore
implements DBStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBStore.class);
    private final DBOptions dbOptions;
    private final WriteOptions writeOptions;
    private final Map<String, ColumnFamilyHandle> handleTable = new HashMap<String, ColumnFamilyHandle>();
    private final ColumnFamilyOptions cfOptions;
    private final List<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
    private final List<ColumnFamilyHandle> columnFamilyHandles = new ArrayList<ColumnFamilyHandle>();
    private final File dbPath;
    private RocksDB rocksDB;

    public RocksDBStore(StorageOptions storageOptions) {
        this.writeOptions = RocksDBStore.createWriteOptions(storageOptions);
        this.dbOptions = RocksDBStore.createDBOptions(storageOptions);
        this.cfOptions = this.createColumnFamilyOptions(storageOptions);
        this.dbPath = storageOptions.getStoragePath();
    }

    private ColumnFamilyOptions createColumnFamilyOptions(StorageOptions storageOptions) {
        return storageOptions.getStorageProfile().getColumnFamilyOptions();
    }

    private static WriteOptions createWriteOptions(StorageOptions opts) {
        WriteOptions writeOptions = new WriteOptions();
        writeOptions.setSync(opts.isSync());
        writeOptions.setDisableWAL(!opts.isSync() && opts.isDisableWAL());
        return writeOptions;
    }

    private static DBOptions createDBOptions(StorageOptions opts) {
        return opts.getStorageProfile().getDBOptions();
    }

    @Override
    public void init() {
        try {
            RocksDBStore.createDbPath(this.dbPath);
            this.cfDescriptors.add(DBColumnFamily.Default.getColumnFamilyDescriptor(this.cfOptions));
            this.cfDescriptors.add(DBColumnFamily.HodorRaft.getColumnFamilyDescriptor(this.cfOptions));
            this.cfDescriptors.add(DBColumnFamily.HodorWatch.getColumnFamilyDescriptor(this.cfOptions));
            this.cfDescriptors.add(DBColumnFamily.HodorWrite.getColumnFamilyDescriptor(this.cfOptions));
            this.cfDescriptors.add(DBColumnFamily.HodorLock.getColumnFamilyDescriptor(this.cfOptions));
            this.cfDescriptors.add(DBColumnFamily.HodorSeq.getColumnFamilyDescriptor(this.cfOptions));
            this.rocksDB = RocksDB.open(this.dbOptions, this.dbPath.getPath(), this.cfDescriptors, this.columnFamilyHandles);
            for (ColumnFamilyHandle columnFamilyHandle : this.columnFamilyHandles) {
                this.handleTable.put(BytesUtil.readUtf8(columnFamilyHandle.getName()), columnFamilyHandle);
            }
        }
        catch (RocksDBException e) {
            throw new StorageDBException("Init DB exception: " + e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug("RocksDB successfully opened.");
            log.debug("[Option] dbPath = {}", (Object)this.dbPath.getAbsolutePath());
            log.debug("[Option] createIfMissing = {}", (Object)this.dbOptions.createIfMissing());
            log.debug("[Option] maxOpenFiles= {}", (Object)this.dbOptions.maxOpenFiles());
        }
    }

    @Override
    public Table<byte[], byte[]> getTable(String name) throws IOException {
        ColumnFamilyHandle handle = this.handleTable.get(name);
        if (handle == null) {
            throw new IOException("No such table in this DB. TableName : " + name);
        }
        return new RocksDBTable(this.rocksDB, handle, this.writeOptions);
    }

    @Override
    public ArrayList<Table<byte[], byte[]>> listTables() {
        ArrayList<Table<byte[], byte[]>> returnList = new ArrayList<Table<byte[], byte[]>>();
        for (ColumnFamilyHandle handle : this.handleTable.values()) {
            returnList.add(new RocksDBTable(this.rocksDB, handle, this.writeOptions));
        }
        return returnList;
    }

    @Override
    public void flushDB() throws IOException {
        try (FlushOptions flushOptions = new FlushOptions();){
            flushOptions.setWaitForFlush(true);
            this.rocksDB.flush(flushOptions);
        }
        catch (RocksDBException e) {
            throw ExceptionHelper.toIOException("Unable to Flush RocksDB data", e);
        }
    }

    @Override
    public void flushLog(boolean sync) throws IOException {
        if (this.rocksDB != null) {
            try {
                this.rocksDB.flushWal(sync);
            }
            catch (RocksDBException e) {
                throw ExceptionHelper.toIOException("Failed to flush db", e);
            }
        }
    }

    @Override
    public void compactDB() throws IOException {
        if (this.rocksDB != null) {
            try {
                this.rocksDB.compactRange();
            }
            catch (RocksDBException e) {
                throw ExceptionHelper.toIOException("Failed to compact db", e);
            }
        }
    }

    private static void createDbPath(File dbPath) {
        if (!dbPath.exists()) {
            try {
                FileUtils.forceMkdir(dbPath);
            }
            catch (IOException e) {
                throw new StorageDBException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void close() {
        for (ColumnFamilyHandle handle : this.handleTable.values()) {
            handle.close();
        }
        this.cfOptions.close();
        if (this.rocksDB != null) {
            this.rocksDB.close();
            this.rocksDB = null;
        }
        if (this.dbOptions != null) {
            this.dbOptions.close();
        }
        if (this.writeOptions != null) {
            this.writeOptions.close();
        }
    }

    static {
        RocksDB.loadLibrary();
    }
}

