/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.dromara.com.google.common.collect.Lists;
import org.dromara.hodor.common.concurrent.LockUtil;
import org.dromara.hodor.common.raft.kv.exception.StorageDBException;
import org.dromara.hodor.common.raft.kv.protocol.KVEntry;
import org.dromara.hodor.common.raft.kv.storage.ByteArrayKeyValue;
import org.dromara.hodor.common.raft.kv.storage.RDBStoreIterator;
import org.dromara.hodor.common.raft.kv.storage.Table;
import org.dromara.hodor.common.raft.kv.storage.TableIterator;
import org.dromara.hodor.common.utils.BytesUtil;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.Holder;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBTable
implements Table<byte[], byte[]> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBTable.class);
    private final RocksDB db;
    private final ColumnFamilyHandle handle;
    private final WriteOptions writeOptions;
    private final ReadWriteLock readWriteLock;

    RocksDBTable(RocksDB db, ColumnFamilyHandle handle, WriteOptions writeOptions) {
        Objects.requireNonNull(db, "RocksDB instance must be not null.");
        Objects.requireNonNull(handle, "ColumnFamilyHandle instance must be not null.");
        Objects.requireNonNull(writeOptions, "Write option must be not null.");
        this.db = db;
        this.handle = handle;
        this.writeOptions = writeOptions;
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        Timer.Context timeCtx = Table.getTimeContext("PUT");
        LockUtil.lockMethod(this.readWriteLock.writeLock(), (k, v) -> {
            try {
                this.db.put(this.handle, this.writeOptions, (byte[])k, (byte[])v);
                Object var4_4 = null;
                return var4_4;
            }
            catch (RocksDBException e) {
                throw new StorageDBException("PUT exception: " + e.getMessage(), e);
            }
            finally {
                timeCtx.stop();
            }
        }, key, value);
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (TableIterator<byte[], ByteArrayKeyValue> keyIter = this.iterator();){
            keyIter.seekToFirst();
            boolean bl = !keyIter.hasNext();
            return bl;
        }
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        Timer.Context timeCtx = Table.getTimeContext("GET");
        return LockUtil.lockMethod(this.readWriteLock.readLock(), k -> {
            try {
                byte[] byArray = this.db.get(this.handle, (byte[])k);
                return byArray;
            }
            catch (RocksDBException e) {
                throw new StorageDBException("GET exception: " + e.getMessage(), e);
            }
            finally {
                timeCtx.stop();
            }
        }, key);
    }

    @Override
    public void delete(byte[] key) throws IOException {
        Timer.Context timeCtx = Table.getTimeContext("GET");
        LockUtil.lockMethod(this.readWriteLock.readLock(), k -> {
            try {
                this.db.delete(this.handle, key);
                Object var4_4 = null;
                return var4_4;
            }
            catch (RocksDBException e) {
                throw new StorageDBException("DELETE exception: " + e.getMessage(), e);
            }
            finally {
                timeCtx.stop();
            }
        }, key);
    }

    @Override
    public TableIterator<byte[], ByteArrayKeyValue> iterator() {
        ReadOptions readOptions = new ReadOptions();
        readOptions.setFillCache(false);
        return new RDBStoreIterator(this.db.newIterator(this.handle, readOptions), this);
    }

    @Override
    public String getName() throws IOException {
        try {
            return BytesUtil.readUtf8(this.handle.getName());
        }
        catch (RocksDBException e) {
            throw new StorageDBException("Get table name exception: " + e.getMessage(), e);
        }
    }

    @Override
    public long getEstimatedKeyCount() {
        try {
            return this.db.getLongProperty(this.handle, "rocksdb.estimate-num-keys");
        }
        catch (RocksDBException e) {
            throw new StorageDBException("Get estimated key count exception: " + e.getMessage(), e);
        }
    }

    @Override
    public List<KVEntry> scan(byte[] startKey, byte[] endKey, boolean returnValue) {
        Timer.Context timeCtx = Table.getTimeContext("SCAN");
        ArrayList<KVEntry> entries = Lists.newArrayList();
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try (RocksIterator it = this.db.newIterator(this.handle);){
            if (startKey == null) {
                it.seekToFirst();
            } else {
                it.seek(startKey);
            }
            while (it.isValid()) {
                byte[] key = it.key();
                if (endKey != null && BytesUtil.getDefaultByteArrayComparator().compare(key, 0, endKey.length, endKey, 0, endKey.length) > 0) {
                    break;
                }
                entries.add(new KVEntry(key, returnValue ? it.value() : null));
                it.next();
            }
        }
        catch (Exception e) {
            throw new StorageDBException("Scan exception: " + e.getMessage(), e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
        return entries;
    }

    @Override
    public Boolean containsKey(byte[] key) {
        Timer.Context timeCtx = Table.getTimeContext("CONTAINS_KEY");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            boolean exists = false;
            Holder<byte[]> valueHolder = new Holder<byte[]>();
            if (this.db.keyMayExist(this.handle, key, valueHolder)) {
                exists = valueHolder.getValue() != null || this.db.get(this.handle, key) != null;
            }
            Boolean bl = exists;
            return bl;
        }
        catch (Exception e) {
            throw new StorageDBException("ContainsKey exception: " + e.getMessage(), e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }
}

