/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import org.dromara.hodor.common.raft.kv.storage.DBStore;
import org.dromara.hodor.common.raft.kv.storage.MemDBStore;
import org.dromara.hodor.common.raft.kv.storage.RocksDBStore;
import org.dromara.hodor.common.raft.kv.storage.StorageOptions;
import org.dromara.hodor.common.raft.kv.storage.StorageType;

public class StorageEngine {
    private final StorageOptions storageOptions;
    private DBStore dbStore;

    public StorageEngine(StorageOptions storageOptions) {
        this.storageOptions = storageOptions;
    }

    public DBStore getRawDBStore() {
        return this.dbStore;
    }

    public void init() throws Exception {
        StorageType storageType = this.storageOptions.getStorageType();
        if (storageType == StorageType.Memory) {
            this.dbStore = new MemDBStore(this.storageOptions);
        }
        if (storageType == StorageType.RocksDB) {
            this.dbStore = new RocksDBStore(this.storageOptions);
        }
        this.dbStore.init();
    }

    public void close() throws Exception {
        this.dbStore.close();
    }
}

