/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.List;
import org.dromara.hodor.common.metrics.KVMetrics;
import org.dromara.hodor.common.raft.kv.protocol.KVEntry;
import org.dromara.hodor.common.raft.kv.storage.TableIterator;

public interface Table<KEY, VALUE> {
    public static Timer.Context getTimeContext(String opName) {
        return KVMetrics.timer("hodor-db-timer", opName).time();
    }

    public void put(KEY var1, VALUE var2) throws IOException;

    public boolean isEmpty() throws IOException;

    public VALUE get(KEY var1) throws IOException;

    public void delete(KEY var1) throws IOException;

    public TableIterator<KEY, ? extends KeyValue<KEY, VALUE>> iterator();

    public String getName() throws IOException;

    public long getEstimatedKeyCount() throws IOException;

    public List<KVEntry> scan(VALUE var1, VALUE var2, boolean var3);

    public Boolean containsKey(VALUE var1);

    public static interface KeyValue<KEY, VALUE> {
        public KEY getKey() throws IOException;

        public VALUE getValue() throws IOException;
    }
}

