/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.raft.kv.storage;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dromara.hodor.common.utils.StringUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;

public class TableConfig {
    private final String name;
    private final ColumnFamilyOptions columnFamilyOptions;

    public TableConfig(String name, ColumnFamilyOptions columnFamilyOptions) {
        this.name = name;
        this.columnFamilyOptions = columnFamilyOptions;
    }

    public String getName() {
        return this.name;
    }

    public ColumnFamilyDescriptor getDescriptor() {
        return new ColumnFamilyDescriptor(StringUtils.string2Bytes(this.name), this.columnFamilyOptions);
    }

    public ColumnFamilyOptions getColumnFamilyOptions() {
        return this.columnFamilyOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableConfig that = (TableConfig)o;
        return new EqualsBuilder().append(this.getName(), that.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.getName()).toHashCode();
    }

    public String toString() {
        return this.getName();
    }
}

