/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.storage.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.dromara.hodor.common.extension.ExtensionLoader;
import org.dromara.hodor.common.storage.db.ColumnConvertBeanProcessor;
import org.dromara.hodor.common.storage.db.HodorDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DBOperator.class);
    private final QueryRunner queryRunner;
    private final DataSource dataSource;
    private final RowProcessor rowProcessor = new BasicRowProcessor(new ColumnConvertBeanProcessor());

    public DBOperator() {
        HodorDataSource hodorDataSource = ExtensionLoader.getExtensionLoader(HodorDataSource.class).getProtoJoin("datasource", new Object[0]);
        Objects.requireNonNull(hodorDataSource, "data source must not be null.");
        this.dataSource = hodorDataSource.getDataSource();
        this.queryRunner = new QueryRunner(this.dataSource);
    }

    public DBOperator(DataSource dataSource) {
        Objects.requireNonNull(dataSource, "data source must not be null.");
        this.dataSource = dataSource;
        this.queryRunner = new QueryRunner(dataSource);
    }

    public boolean createTableIfNeeded(String tableName, String sql) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             ResultSet resultSet = connection.getMetaData().getTables(null, null, tableName.toUpperCase(), new String[]{"TABLE"});){
            if (!resultSet.next()) {
                this.queryRunner.update(connection, sql);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public <T> T query(String querySql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.queryRunner.query(querySql, rsh, params);
    }

    public <T> T query(String querySql, Class<T> clazz, Object ... params) throws SQLException {
        T result = this.queryRunner.query(querySql, new BeanHandler<T>(clazz, this.rowProcessor), params);
        log.debug("query result: {}", (Object)result);
        return result;
    }

    public <T> List<T> queryList(String querySql, Class<T> clazz, Object ... params) throws SQLException {
        List result = (List)this.queryRunner.query(querySql, new BeanListHandler<T>(clazz, this.rowProcessor), params);
        log.debug("query list result: {}", (Object)result);
        return result;
    }

    public int update(String updateSql, Object ... params) throws SQLException {
        int update = this.queryRunner.update(updateSql, params);
        log.debug("update result: {}", (Object)update);
        return update;
    }
}

