/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.storage.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.util.PropertyElf;
import java.util.Objects;
import org.dromara.hodor.common.extension.Join;
import org.dromara.hodor.common.storage.db.AbstractHodorDataSource;
import org.dromara.hodor.common.storage.db.DataSourceConfig;
import org.dromara.hodor.common.utils.StringUtils;

@Join
public class H2FileDataSource
extends AbstractHodorDataSource {
    private static final String H2_DATASOURCE_CLASS_NAME = "org.h2.jdbcx.JdbcDataSource";
    private static final String H2_URL = String.format("jdbc:h2:file:%s/hodorScheduler/db_hodor;IGNORECASE=TRUE", System.getProperty("user.dir"));

    public H2FileDataSource(DataSourceConfig dataSourceConfig) {
        super(dataSourceConfig);
        HikariConfig config = new HikariConfig();
        if (dataSourceConfig == null) {
            config.setDataSourceClassName(H2_DATASOURCE_CLASS_NAME);
            config.addDataSourceProperty("URL", H2_URL);
            this.setDataSource(new HikariDataSource(config));
            return;
        }
        String dataSourceClassName = dataSourceConfig.getDataSourceClassName();
        String url = dataSourceConfig.getUrl();
        Objects.requireNonNull(url, "data source url must not be null.");
        config.setDataSourceClassName(dataSourceClassName == null ? H2_DATASOURCE_CLASS_NAME : dataSourceClassName);
        config.addDataSourceProperty("URL", url);
        PropertyElf.setTargetFromProperties(config, dataSourceConfig.getDataSourceProperties());
        String username = dataSourceConfig.getUsername();
        String password = dataSourceConfig.getPassword();
        if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
            config.setUsername(username);
            config.setPassword(password);
        }
        this.setDataSource(new HikariDataSource(config));
    }

    @Override
    public String getDBType() {
        return "h2-file";
    }
}

