/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.storage.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.util.PropertyElf;
import java.util.Objects;
import org.dromara.hodor.common.extension.Join;
import org.dromara.hodor.common.storage.db.AbstractHodorDataSource;
import org.dromara.hodor.common.storage.db.DataSourceConfig;

@Join
public class MySQLDataSource
extends AbstractHodorDataSource {
    public MySQLDataSource(DataSourceConfig dataSourceConfig) {
        super(dataSourceConfig);
        Objects.requireNonNull(dataSourceConfig, "data source config must not be null.");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(dataSourceConfig.getUrl());
        config.setUsername(dataSourceConfig.getUsername());
        config.setPassword(dataSourceConfig.getPassword());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        PropertyElf.setTargetFromProperties(config, dataSourceConfig.getDataSourceProperties());
        this.setDataSource(new HikariDataSource(config));
    }

    @Override
    public String getDBType() {
        return "mysql";
    }
}

