/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dromara.com.google.common.collect.Lists;
import org.dromara.com.google.common.collect.Maps;
import org.dromara.com.google.common.collect.Sets;

public class CopySets {
    public static List<List<String>> buildCopySets(List<String> nodes, int r, int s2) {
        boolean present;
        if (nodes.size() <= r) {
            ArrayList<List<String>> result = Lists.newArrayList();
            result.add(nodes);
            return result;
        }
        ArrayList<Set<String>> copySets = Lists.newArrayList();
        HashMap<String, Integer> scatterWidths = Maps.newHashMap();
        nodes.sort(Comparable::compareTo);
        do {
            boolean modified = false;
            for (String node : nodes) {
                if (scatterWidths.getOrDefault(node, 0) >= s2) continue;
                HashSet<String> copySet = Sets.newHashSet(node);
                ArrayList<String> sortedNodes = Lists.newArrayList();
                for (String n2 : nodes) {
                    scatterWidths.putIfAbsent(n2, 0);
                    if (n2.equals(node)) continue;
                    sortedNodes.add(n2);
                    sortedNodes.sort(Comparator.comparingInt(scatterWidths::get));
                }
                for (String sortedNode : sortedNodes) {
                    copySet.add(sortedNode);
                    if (!CopySets.checker(copySets, copySet) || copySets.contains(copySet)) {
                        copySet.remove(sortedNode);
                        continue;
                    }
                    if (copySet.size() != r) continue;
                    copySets.add(copySet);
                    modified = true;
                    break;
                }
                HashMap<String, Set> scatterSets = Maps.newHashMap();
                for (Set set : copySets) {
                    for (String n3 : set) {
                        HashSet result = Sets.newHashSet(set);
                        HashSet<String> tmp = Sets.newHashSet(n3);
                        result.removeAll(tmp);
                        scatterSets.putIfAbsent(n3, Sets.newHashSet());
                        ((Set)scatterSets.get(n3)).addAll(result);
                    }
                }
                scatterSets.forEach((k, v) -> scatterWidths.put((String)k, v.size()));
            }
            if (modified) continue;
            throw new RuntimeException("Couldn't create valid copySets");
        } while (present = nodes.stream().anyMatch(n -> (Integer)scatterWidths.get(n) < s2));
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        copySets.forEach(e -> {
            ArrayList list = new ArrayList(e);
            list.sort(Comparable::compareTo);
            result.add(list);
        });
        return result;
    }

    private static boolean checker(List<Set<String>> copysets, Set<String> copyset) {
        return true;
    }
}

