/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.dromara.hodor.common.utils.StringUtils;

public class GsonUtils {
    private static final GsonUtils INSTANCE = new GsonUtils();
    private static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        @Override
        public void write(JsonWriter out, String value) {
            if (StringUtils.isBlank(value)) {
                out.nullValue();
                return;
            }
            out.value(value);
        }

        @Override
        public String read(JsonReader reader) {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return "";
            }
            return reader.nextString();
        }
    };
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)String.class), STRING).registerTypeAdapter((Type)((Object)byte[].class), new ByteArrayTypeAdapter()).registerTypeHierarchyAdapter(new TypeToken<Map<String, Object>>(){}.getRawType(), new MapDeserializer()).create();
    private static final Gson GSON_MAP = new GsonBuilder().serializeNulls().registerTypeHierarchyAdapter(new TypeToken<Map<String, Object>>(){}.getRawType(), new MapDeserializer()).create();
    private static final String DOT = ".";
    private static final String E = "e";

    public static Gson getGson() {
        return GSON;
    }

    public static GsonUtils getInstance() {
        return INSTANCE;
    }

    public String toJson(Object object) {
        return GSON.toJson(object);
    }

    public <T> T fromJson(String json, Class<T> tClass) {
        return GSON.fromJson(json, tClass);
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> tClass) {
        return GSON.fromJson(jsonElement, tClass);
    }

    public <T> T fromJson(String json, Type typeOfT) {
        return GSON.fromJson(json, typeOfT);
    }

    public <T> List<T> fromList(String json, Class<T> clazz) {
        return (List)GSON.fromJson(json, TypeToken.getParameterized(List.class, new Type[]{clazz}).getType());
    }

    public String toGetParam(String json) {
        if (StringUtils.isBlank(json)) {
            return "";
        }
        Map<String, String> map = this.toStringMap(json);
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((k, v) -> {
            try {
                stringBuilder.append((String)k).append("=").append(URLDecoder.decode(v, "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        });
        String r = stringBuilder.toString();
        return r.substring(0, r.lastIndexOf("&"));
    }

    private Map<String, String> toStringMap(String json) {
        return (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    public List<Map<String, Object>> toListMap(String json) {
        return (List)GSON.fromJson(json, new TypeToken<List<Map<String, Object>>>(){}.getType());
    }

    public Map<String, Object> toObjectMap(String json) {
        return (Map)GSON_MAP.fromJson(json, new TypeToken<LinkedHashMap<String, Object>>(){}.getType());
    }

    public ConcurrentSkipListMap<String, Object> toTreeMap(String json) {
        return (ConcurrentSkipListMap)GSON_MAP.fromJson(json, new TypeToken<ConcurrentSkipListMap<String, Object>>(){}.getType());
    }

    public Map<String, Object> convertToMap(String json) {
        Map map = (Map)GSON_MAP.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
        if (!map.isEmpty()) {
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value instanceof String) {
                    String valueStr = ((String)value).trim();
                    if (!valueStr.startsWith("{") || !valueStr.endsWith("}")) continue;
                    Map<String, Object> mv = this.convertToMap(value.toString());
                    map.put(key, mv);
                    continue;
                }
                if (value instanceof JsonObject) {
                    map.put(key, this.convertToMap(value.toString()));
                    continue;
                }
                if (!(value instanceof JsonArray)) continue;
                JsonArray jsonArray = (JsonArray)value;
                ArrayList<Object> mapList = new ArrayList<Object>(jsonArray.size());
                for (JsonElement object : jsonArray) {
                    String objStr = this.toJson(object);
                    if (objStr.startsWith("{") && objStr.endsWith("}")) {
                        mapList.add(this.convertToMap(((Object)object).toString()));
                        continue;
                    }
                    mapList.add(objStr);
                }
                map.put(key, mapList);
            }
        }
        return map;
    }

    public static class ByteArrayTypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        @Override
        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String base64 = json.getAsString();
            return Base64.getDecoder().decode(base64);
        }

        @Override
        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            String base64 = Base64.getEncoder().encodeToString(src);
            return new JsonPrimitive(base64);
        }
    }

    private static class MapDeserializer<T, U>
    implements JsonDeserializer<Map<T, U>> {
        private MapDeserializer() {
        }

        @Override
        public Map<T, U> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            Set<Map.Entry<String, JsonElement>> jsonEntrySet = jsonObject.entrySet();
            LinkedHashMap resultMap = new LinkedHashMap();
            for (Map.Entry<String, JsonElement> entry : jsonEntrySet) {
                Object value = context.deserialize(entry.getValue(), this.getType(entry.getValue()));
                resultMap.put(entry.getKey(), value);
            }
            return resultMap;
        }

        public Class<?> getType(JsonElement element) {
            if (!element.isJsonPrimitive()) {
                return Map.class;
            }
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return String.class;
            }
            if (primitive.isNumber()) {
                String numStr = primitive.getAsString();
                if (numStr.contains(GsonUtils.DOT) || numStr.contains(GsonUtils.E) || numStr.contains("E")) {
                    return Double.class;
                }
                if (Long.parseLong(numStr) <= Integer.MAX_VALUE) {
                    return Integer.class;
                }
                return Long.class;
            }
            if (primitive.isBoolean()) {
                return Boolean.class;
            }
            return element.getClass();
        }
    }
}

