/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import cn.hutool.core.util.RuntimeUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.dromara.hodor.common.exception.HodorException;

public final class HostUtils {
    private static volatile String cachedIpAddress;
    private static volatile String hostName;

    public static String getLocalIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (null != cachedIpAddress) {
            return cachedIpAddress;
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new HodorException(ex);
        }
        String localIpAddress = null;
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = netInterfaces.nextElement();
            Enumeration<InetAddress> ipAddresses = netInterface.getInetAddresses();
            while (ipAddresses.hasMoreElements()) {
                InetAddress ipAddress = ipAddresses.nextElement();
                if (HostUtils.isPublicIpAddress(ipAddress)) {
                    String publicIpAddress;
                    cachedIpAddress = publicIpAddress = ipAddress.getHostAddress();
                    return publicIpAddress;
                }
                if (!HostUtils.isLocalIpAddress(ipAddress)) continue;
                localIpAddress = ipAddress.getHostAddress();
            }
        }
        cachedIpAddress = localIpAddress;
        return localIpAddress;
    }

    public static String getLocalHostName() {
        if (hostName == null) {
            hostName = HostUtils.getLocalHost().getHostName();
        }
        return hostName;
    }

    private static boolean isPublicIpAddress(InetAddress ipAddress) {
        return !ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !HostUtils.isV6IpAddress(ipAddress);
    }

    private static boolean isLocalIpAddress(InetAddress ipAddress) {
        return ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !HostUtils.isV6IpAddress(ipAddress);
    }

    private static boolean isV6IpAddress(InetAddress ipAddress) {
        return ipAddress.getHostAddress().contains(":");
    }

    private static InetAddress getLocalHost() {
        InetAddress result;
        try {
            result = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new HodorException(ex);
        }
        return result;
    }

    public static boolean isLocalIp(String ip) {
        Enumeration<NetworkInterface> netInterfaces;
        boolean flag = false;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new HodorException(ex);
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = netInterfaces.nextElement();
            Enumeration<InetAddress> ipAddresses = netInterface.getInetAddresses();
            while (ipAddresses.hasMoreElements()) {
                InetAddress ipAddress = ipAddresses.nextElement();
                if (!ipAddress.getHostAddress().equals(ip)) continue;
                return true;
            }
        }
        return flag;
    }

    public static String getIp(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return inetSocketAddress.getAddress().getHostAddress();
    }

    public static String getHostName(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return inetSocketAddress.getAddress().getHostName();
    }

    public static Integer getPort(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return inetSocketAddress.getPort();
    }

    public static int getPid() {
        return RuntimeUtil.getPid();
    }
}

