/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.dromara.hodor.common.exception.UndefinedPropertyException;

public class Props {
    private final Map<String, Object> _current = new HashMap<String, Object>();
    private Props _parent;
    private String source = null;

    public Props() {
        this(null);
    }

    public Props(Props parent) {
        this._parent = parent;
    }

    public Props(Props parent, String filepath) throws IOException {
        this(parent, new File(filepath));
    }

    public Props(Props parent, File file) throws IOException {
        this(parent);
        this.setSource(file.getPath());
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            this.loadFrom(input);
        }
    }

    public Props(Props parent, InputStream inputStream) throws IOException {
        this(parent);
        this.loadFrom(inputStream);
    }

    @SafeVarargs
    public Props(Props parent, Map<String, Object> ... props) {
        this(parent);
        for (int i = props.length - 1; i >= 0; --i) {
            this.putAll(props[i]);
        }
    }

    public Props(Props parent, Properties ... properties) {
        this(parent);
        for (int i = properties.length - 1; i >= 0; --i) {
            this.put(properties[i]);
        }
    }

    public Props(Props parent, Props props) {
        this(parent);
        if (props != null) {
            this.putAll(props);
        }
    }

    public static Props of(String ... args) {
        return Props.of((Props)null, args);
    }

    public static Props of(Props parent, String ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Must have an equal number of keys and values.");
        }
        HashMap<String, String> vals = new HashMap<String, String>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            vals.put(args[i], args[i + 1]);
        }
        return new Props(parent, vals);
    }

    public static Props clone(Props p) {
        return Props.copyNext(p);
    }

    private static Props copyNext(Props source) {
        Props priorNodeCopy = null;
        if (source.getParent() != null) {
            priorNodeCopy = Props.copyNext(source.getParent());
        }
        Props dest = new Props(priorNodeCopy);
        for (String key : source.localKeySet()) {
            dest.put(key, source.get(key));
        }
        return dest;
    }

    private void loadFrom(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.put(properties);
    }

    public Props getEarliestAncestor() {
        if (this._parent == null) {
            return this;
        }
        return this._parent.getEarliestAncestor();
    }

    public void setEarliestAncestor(Props parent) {
        Props props = this.getEarliestAncestor();
        props.setParent(parent);
    }

    public void clearLocal() {
        this._current.clear();
    }

    public boolean containsKey(Object k) {
        return this._current.containsKey(k) || this._parent != null && this._parent.containsKey(k);
    }

    public boolean containsValue(Object value) {
        return this._current.containsValue(value) || this._parent != null && this._parent.containsValue(value);
    }

    public Object get(Object key) {
        if (this._current.containsKey(key)) {
            return this._current.get(key);
        }
        if (this._parent != null) {
            return this._parent.get(key);
        }
        return null;
    }

    public <T> T getObj(Object key) {
        Object result = this.get(key);
        if (result == null) {
            return null;
        }
        return (T)result;
    }

    public Set<String> localKeySet() {
        return this._current.keySet();
    }

    public Props getParent() {
        return this._parent;
    }

    public void setParent(Props prop) {
        this._parent = prop;
    }

    public Object put(String key, Object value) {
        return this._current.put(key, value);
    }

    public void put(Properties properties) {
        for (String propName : properties.stringPropertyNames()) {
            this._current.put(propName, StringUtils.trim(properties.getProperty(propName)));
        }
    }

    public void put(File propertiesFile) {
        if (propertiesFile == null || !propertiesFile.exists() || !propertiesFile.canRead()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
            this.put(properties);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void putIfAbsent(Properties properties) {
        for (String propName : properties.stringPropertyNames()) {
            if (this.containsKey(propName)) continue;
            this._current.put(propName, StringUtils.trim(properties.getProperty(propName)));
        }
    }

    public void putIfAbsent(File propertiesFile) {
        if (propertiesFile == null || !propertiesFile.exists() || !propertiesFile.canRead()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
            this.putIfAbsent(properties);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Integer put(String key, Integer value) {
        return (Integer)this._current.put(key, value);
    }

    public Long put(String key, Long value) {
        return (Long)this._current.put(key, value);
    }

    public Double put(String key, Double value) {
        return (Double)this._current.put(key, value);
    }

    public void putAll(Map<String, ?> m4) {
        if (m4 == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : m4.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Props p) {
        if (p == null) {
            return;
        }
        for (String key : p.getKeySet()) {
            this.put(key, p.get(key));
        }
    }

    public void putAll(String props) {
        if (StringUtils.isBlank(props)) {
            return;
        }
        if (props.startsWith("-D")) {
            props = props.replace("-D", "\n");
        }
        Properties properties = new Properties();
        CharSequenceReader reader = new CharSequenceReader(props);
        try {
            properties.load(reader);
            this.put(properties);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void putLocal(Props p) {
        for (String key : p.localKeySet()) {
            this.put(key, p.get(key));
        }
    }

    public Object removeLocal(Object s2) {
        return this._current.remove(s2);
    }

    public int size() {
        return this.getKeySet().size();
    }

    public int localSize() {
        return this._current.size();
    }

    public Class<?> getClass(String key) {
        try {
            if (this.containsKey(key)) {
                return Class.forName((String)this.get(key));
            }
            throw new UndefinedPropertyException("Missing required property '" + key + "'");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Class<?> getClass(String key, boolean initialize, ClassLoader cl) {
        try {
            if (this.containsKey(key)) {
                return Class.forName((String)this.get(key), initialize, cl);
            }
            throw new UndefinedPropertyException("Missing required property '" + key + "'");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Class<?> getClass(String key, Class<?> defaultClass) {
        if (this.containsKey(key)) {
            return this.getClass(key);
        }
        return defaultClass;
    }

    public String getString(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return String.valueOf(this.get(key));
        }
        return defaultValue;
    }

    public String getString(String key) {
        if (this.containsKey(key)) {
            return String.valueOf(this.get(key));
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, "\\s*,\\s*");
    }

    public List<String> getStringListFromCluster(String key) {
        List<String> curlist = this.getStringList(key, "\\s*;\\s*");
        ListIterator<String> iter = curlist.listIterator();
        while (iter.hasNext()) {
            String a = (String)iter.next();
            if (a.length() != 0) continue;
            iter.remove();
        }
        return curlist;
    }

    public List<String> getStringList(String key, String sep) {
        String val = (String)this.get(key);
        if (val == null || val.trim().length() == 0) {
            return Collections.emptyList();
        }
        if (this.containsKey(key)) {
            return Arrays.asList(val.split(sep));
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public List<String> getStringList(String key, List<String> defaultValue) {
        if (this.containsKey(key)) {
            return this.getStringList(key);
        }
        return defaultValue;
    }

    public List<String> getStringList(String key, List<String> defaultValue, String sep) {
        if (this.containsKey(key)) {
            return this.getStringList(key, sep);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object obj = this.get(key);
        if (obj == null) {
            return defaultValue;
        }
        try {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            return Boolean.parseBoolean((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Boolean.");
        }
    }

    public boolean getBoolean(String key) {
        if (this.containsKey(key)) {
            return "true".equalsIgnoreCase((String)this.get(key));
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public long getLong(String name, long defaultValue) {
        if (this.containsKey(name)) {
            return this.get(name) instanceof Long ? (Long)this.get(name) : Long.parseLong((String)this.get(name));
        }
        return defaultValue;
    }

    public long getLong(String name) {
        Object obj = this.get(name);
        try {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            return Long.parseLong((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Long.");
        }
    }

    public int getInt(String name, int defaultValue) {
        Object obj = this.get(name);
        if (obj == null) {
            return defaultValue;
        }
        try {
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            return Integer.parseInt((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not an Integer.");
        }
    }

    public int getInt(String name) {
        Object obj = this.get(name);
        try {
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            return Integer.parseInt((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not an Integer.");
        }
    }

    public double getDouble(String name, double defaultValue) {
        Object obj = this.get(name);
        if (obj == null) {
            return defaultValue;
        }
        try {
            if (obj instanceof Double) {
                return (Double)obj;
            }
            return Double.parseDouble((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Double.");
        }
    }

    public double getDouble(String name) {
        Object obj = this.get(name);
        try {
            if (obj instanceof Double) {
                return (Double)obj;
            }
            return Double.parseDouble((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Double.");
        }
    }

    public URI getUri(String name) {
        if (this.containsKey(name)) {
            try {
                return new URI((String)this.get(name));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        throw new UndefinedPropertyException("Missing required property '" + name + "'");
    }

    public URI getUri(String name, URI defaultValue) {
        if (this.containsKey(name)) {
            return this.getUri(name);
        }
        return defaultValue;
    }

    public URI getUri(String name, String defaultValue) {
        try {
            return this.getUri(name, new URI(defaultValue));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void storeLocal(File file) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.storeLocal(out);
        }
    }

    public Props local() {
        return new Props(null, this._current);
    }

    public void storeLocal(OutputStream out) throws IOException {
        Properties p = new Properties();
        for (String key : this._current.keySet()) {
            p.setProperty(key, String.valueOf(this.get(key)));
        }
        p.store(out, null);
    }

    public Properties toProperties() {
        Properties p = new Properties();
        for (String key : this._current.keySet()) {
            p.setProperty(key, String.valueOf(this.get(key)));
        }
        return p;
    }

    public Properties toAllProperties() {
        Properties allProp = new Properties();
        allProp.putAll((Map<?, ?>)this.toProperties());
        if (this._parent != null) {
            allProp.putAll((Map<?, ?>)this._parent.toProperties());
        }
        return allProp;
    }

    public void storeFlattened(File file) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.storeFlattened(out);
        }
    }

    public void storeFlattened(OutputStream out) throws IOException {
        Properties p = new Properties();
        for (Props curr = this; curr != null; curr = curr.getParent()) {
            for (String key : curr.localKeySet()) {
                if (p.containsKey(key)) continue;
                p.setProperty(key, String.valueOf(this.get(key)));
            }
        }
        p.store(out, null);
    }

    public Map<String, String> getFlattened() {
        TreeMap<String, String> returnVal = new TreeMap<String, String>();
        returnVal.putAll(this.getMapByPrefix(""));
        return returnVal;
    }

    public Map<String, String> getMapByPrefix(String prefix) {
        HashMap<String, String> values = this._parent == null ? new HashMap() : this._parent.getMapByPrefix(prefix);
        for (String key : this.localKeySet()) {
            if (!key.startsWith(prefix)) continue;
            values.put(key.substring(prefix.length()), String.valueOf(this.get(key)));
        }
        return values;
    }

    public Set<String> getKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.localKeySet());
        if (this._parent != null) {
            keySet.addAll(this._parent.getKeySet());
        }
        return keySet;
    }

    public void logProperties(Logger logger, String comment) {
        logger.info(comment);
        for (String key : this.getKeySet()) {
            logger.info("  key=" + key + " value=" + this.get(key));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != Props.class) {
            return false;
        }
        Props p = (Props)o;
        return this._current.equals(p._current) && Objects.equals(this._parent, p._parent);
    }

    public boolean equalsProps(Props p) {
        if (p == null) {
            return false;
        }
        Set<String> myKeySet = this.getKeySet();
        for (String s2 : myKeySet) {
            if (this.get(s2).equals(p.get(s2))) continue;
            return false;
        }
        return myKeySet.size() == p.getKeySet().size();
    }

    public int hashCode() {
        int code = this._current.hashCode();
        if (this._parent != null) {
            code += this._parent.hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        for (Map.Entry<String, Object> entry : this._current.entrySet()) {
            builder.append(entry.getKey());
            builder.append(": ");
            builder.append(entry.getValue());
            builder.append(", ");
        }
        if (this._parent != null) {
            builder.append(" parent = ");
            builder.append(this._parent.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

