/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.dromara.com.google.common.collect.MapDifference;
import org.dromara.com.google.common.collect.Maps;
import org.dromara.hodor.common.exception.UndefinedPropertyException;
import org.dromara.hodor.common.utils.Props;
import org.dromara.hodor.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropsUtils.class);
    private static final Pattern VARIABLE_REPLACEMENT_PATTERN = Pattern.compile("\\$\\{([a-zA-Z_.0-9]+)}");

    public static Props loadPropsInDir(File dir, String ... suffixes) {
        return PropsUtils.loadPropsInDir(null, dir, suffixes);
    }

    public static Props loadPropsInDir(Props parent, File dir, String ... suffixes) {
        try {
            Props props = new Props(parent);
            Object[] files = dir.listFiles();
            if (files == null) {
                return props;
            }
            Arrays.sort(files);
            for (Object f : files) {
                if (!((File)f).isFile() || !PropsUtils.endsWith((File)f, suffixes)) continue;
                props.putAll(new Props(null, ((File)f).getAbsolutePath()));
            }
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties.", e);
        }
    }

    public static Props loadProps(Props parent, File ... propFiles) {
        try {
            Props props = new Props(parent);
            for (File f : propFiles) {
                if (!f.isFile()) continue;
                props = new Props(props, f);
            }
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties.", e);
        }
    }

    public static Props loadPropsInDirs(List<File> dirs, String ... suffixes) {
        Props props = new Props();
        for (File dir : dirs) {
            props.putLocal(PropsUtils.loadPropsInDir(dir, suffixes));
        }
        return props;
    }

    public static void loadPropsBySuffix(File jobPath, Props props, String ... suffixes) {
        try {
            if (jobPath.isDirectory()) {
                File[] files = jobPath.listFiles();
                if (files != null) {
                    for (File file : files) {
                        PropsUtils.loadPropsBySuffix(file, props, suffixes);
                    }
                }
            } else if (PropsUtils.endsWith(jobPath, suffixes)) {
                props.putAll(new Props(null, jobPath.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading schedule properties.", e);
        }
    }

    public static boolean endsWith(File file, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!file.getName().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVariableReplacementPattern(String str) {
        Matcher matcher = VARIABLE_REPLACEMENT_PATTERN.matcher(str);
        return matcher.matches();
    }

    public static Props resolveProps(Props props) {
        if (props == null) {
            return null;
        }
        Props objProps = new Props();
        Props resolvedProps = new Props();
        LinkedHashSet<String> visitedVariables = new LinkedHashSet<String>();
        for (String key : props.getKeySet()) {
            Object val = props.get(key);
            if (val == null) {
                log.warn("Null value in props for key '" + key + "'. Replacing with empty string.");
                val = "";
            }
            if (!(val instanceof String)) {
                objProps.put(key, val);
                continue;
            }
            String value = (String)val;
            visitedVariables.add(key);
            String replacedValue = PropsUtils.resolveVariableReplacement(value, props, visitedVariables);
            visitedVariables.clear();
            resolvedProps.put(key, replacedValue);
        }
        for (String key : resolvedProps.getKeySet()) {
            String value = resolvedProps.getString(key);
            String expressedValue = PropsUtils.resolveVariableExpression(value);
            resolvedProps.put(key, expressedValue);
        }
        resolvedProps.putAll(objProps);
        return resolvedProps;
    }

    private static String resolveVariableReplacement(String value, Props props, LinkedHashSet<String> visitedVariables) {
        StringBuffer buffer = new StringBuffer();
        int startIndex = 0;
        Matcher matcher = VARIABLE_REPLACEMENT_PATTERN.matcher(value);
        while (matcher.find(startIndex)) {
            String subVariable;
            if (startIndex < matcher.start()) {
                buffer.append(value.substring(startIndex, matcher.start()));
            }
            if (visitedVariables.contains(subVariable = matcher.group(1))) {
                throw new IllegalArgumentException(String.format("Circular variable substitution found: [%s] -> [%s]", StringUtils.join(visitedVariables, "->"), subVariable));
            }
            String replacement = props.getString(subVariable);
            visitedVariables.add(subVariable);
            if (replacement == null) {
                throw new UndefinedPropertyException(String.format("Could not find variable substitution for variable(s) [%s]", StringUtils.join(visitedVariables, "->")));
            }
            buffer.append(PropsUtils.resolveVariableReplacement(replacement, props, visitedVariables));
            visitedVariables.remove(subVariable);
            startIndex = matcher.end();
        }
        if (startIndex < value.length()) {
            buffer.append(value.substring(startIndex));
        }
        return buffer.toString();
    }

    private static String resolveVariableExpression(String value) {
        JexlEngine jexl = new JexlEngine();
        return PropsUtils.resolveVariableExpression(value, value.length(), jexl);
    }

    private static String resolveVariableExpression(String value, int last, JexlEngine jexl) {
        int nextClosed;
        int lastIndex = value.lastIndexOf("$(", last);
        if (lastIndex == -1) {
            return value;
        }
        int bracketCount = 0;
        for (nextClosed = lastIndex + 2; nextClosed < value.length(); ++nextClosed) {
            if (value.charAt(nextClosed) == '(') {
                ++bracketCount;
                continue;
            }
            if (value.charAt(nextClosed) == ')' && --bracketCount == -1) break;
        }
        if (nextClosed == value.length()) {
            throw new IllegalArgumentException("Expression " + value + " not well formed.");
        }
        String innerExpression = value.substring(lastIndex + 2, nextClosed);
        Object result = null;
        try {
            Expression e = jexl.createExpression(innerExpression);
            MapContext context = new MapContext();
            Calendar calendar = Calendar.getInstance();
            context.set("DATE", calendar.getTime());
            context.set("TIMESTAMP", calendar.getTimeInMillis());
            context.set("YEAR", calendar.get(1));
            context.set("MONTH", calendar.get(2) + 1 > 9 ? Integer.valueOf(calendar.get(2) + 1) : "0" + (calendar.get(2) + 1));
            context.set("DAY", calendar.get(5) + 1 > 9 ? Integer.valueOf(calendar.get(5) + 1) : "0" + (calendar.get(5) + 1));
            context.set("HOUR", calendar.get(11) + 1 > 9 ? Integer.valueOf(calendar.get(11) + 1) : "0" + (calendar.get(11) + 1));
            context.set("MINUTE", calendar.get(12));
            context.set("SECOND", calendar.get(13));
            result = e.evaluate(context);
        }
        catch (JexlException e) {
            throw new IllegalArgumentException("Expression " + value + " not well formed. " + e.getMessage(), e);
        }
        if (result == null) {
            return value;
        }
        String newValue = value.substring(0, lastIndex) + result.toString() + value.substring(nextClosed + 1);
        return PropsUtils.resolveVariableExpression(newValue, lastIndex, jexl);
    }

    public static Map<String, String> toStringMap(Props props, boolean localOnly) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> keyset = localOnly ? props.localKeySet() : props.getKeySet();
        for (String key : keyset) {
            String value = props.getString(key);
            map.put(key, value);
        }
        return map;
    }

    public static Props fromHierarchicalMap(Map<String, Object> propsMap) {
        if (propsMap == null) {
            return null;
        }
        String source = (String)propsMap.get("source");
        Map propsParams = (Map)propsMap.get("props");
        Map parent = (Map)propsMap.get("parent");
        Props parentProps = PropsUtils.fromHierarchicalMap(parent);
        Props props = new Props(parentProps, propsParams);
        props.setSource(source);
        return props;
    }

    public static Map<String, Object> toHierarchicalMap(Props props) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        propsMap.put("source", props.getSource());
        propsMap.put("props", PropsUtils.toStringMap(props, true));
        if (props.getParent() != null) {
            propsMap.put("parent", PropsUtils.toHierarchicalMap(props.getParent()));
        }
        return propsMap;
    }

    public static String getPropertyDiff(Props oldProps, Props newProps) {
        Map<String, MapDifference.ValueDifference<String>> map;
        Map<String, String> deletedProperty;
        MapDifference<String, String> md;
        Map<String, String> newlyCreatedProperty;
        StringBuilder builder = new StringBuilder();
        if (oldProps == null) {
            oldProps = new Props();
        }
        if (newProps == null) {
            newProps = new Props();
        }
        if ((newlyCreatedProperty = (md = Maps.difference(PropsUtils.toStringMap(oldProps, false), PropsUtils.toStringMap(newProps, false))).entriesOnlyOnRight()).size() > 0) {
            builder.append("Newly created Properties: ");
            for (Map.Entry<String, String> entry : newlyCreatedProperty.entrySet()) {
                builder.append("[ ").append(entry.getKey()).append(", ").append(entry.getValue()).append("], ");
            }
            builder.append("\n");
        }
        if ((deletedProperty = md.entriesOnlyOnLeft()).size() > 0) {
            builder.append("Deleted Properties: ");
            for (Map.Entry<String, String> entry : deletedProperty.entrySet()) {
                builder.append("[ ").append(entry.getKey()).append(", ").append(entry.getValue()).append("], ");
            }
            builder.append("\n");
        }
        if ((map = md.entriesDiffering()).size() > 0) {
            builder.append("Modified Properties: ");
            for (Map.Entry<String, MapDifference.ValueDifference<String>> entry : map.entrySet()) {
                builder.append("[ ").append(entry.getKey()).append(", ").append(entry.getValue()).append("], ");
            }
        }
        return builder.toString();
    }
}

