/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ProtostuffUtils {
    private static final ThreadLocal<LinkedBuffer> bufThreadLocal = ThreadLocal.withInitial(() -> LinkedBuffer.allocate(512));
    private static final Map<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] serialize(T obj) {
        byte[] data;
        Class<?> clazz = obj.getClass();
        Schema<?> schema = ProtostuffUtils.getSchema(clazz);
        LinkedBuffer buffer = ProtostuffUtils.getLinkedBuffer();
        try {
            data = ProtobufIOUtil.toByteArray(obj, schema, buffer);
        }
        finally {
            ProtostuffUtils.resetBuf(buffer);
        }
        return data;
    }

    public static <T> T deserialize(byte[] data, Class<T> clazz) {
        Schema<T> schema = ProtostuffUtils.getSchema(clazz);
        T obj = schema.newMessage();
        ProtobufIOUtil.mergeFrom(data, obj, schema);
        return obj;
    }

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        Schema<Object> schema = schemaCache.get(clazz);
        if (Objects.isNull(schema) && Objects.nonNull(schema = RuntimeSchema.getSchema(clazz))) {
            schemaCache.put(clazz, schema);
        }
        return schema;
    }

    private static LinkedBuffer getLinkedBuffer() {
        return bufThreadLocal.get();
    }

    private static void resetBuf(LinkedBuffer buf) {
        buf.clear();
    }
}

