/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import org.apache.commons.lang3.RandomUtils;
import org.dromara.hodor.common.utils.HostUtils;
import org.dromara.hodor.common.utils.StringUtils;

public class SnowflakeIdWorker {
    private static final long twepoch = 1420041600000L;
    private static final long workerIdBits = 5L;
    private static final long dataCenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDataCenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long dataCenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static SnowflakeIdWorker idWorker = new SnowflakeIdWorker(SnowflakeIdWorker.getWorkId(), SnowflakeIdWorker.getDataCenterId());

    public SnowflakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = dataCenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.untilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1420041600000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    protected long untilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    private static Long getWorkId() {
        try {
            String hostAddress = HostUtils.getLocalIp();
            int pid = HostUtils.getPid();
            int[] ints = StringUtils.toCodePoints(hostAddress + pid);
            int sums = 0;
            for (int b : ints) {
                sums += b;
            }
            return sums % 32;
        }
        catch (Exception e) {
            return RandomUtils.nextLong(0L, 31L);
        }
    }

    private static Long getDataCenterId() {
        int[] ints = StringUtils.toCodePoints(HostUtils.getLocalHostName());
        int sums = 0;
        for (int i : ints) {
            sums += i;
        }
        return sums % 32;
    }

    public static long nextUniqId() {
        return idWorker.nextId();
    }
}

