/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.text.TextStringBuilder;
import org.dromara.com.google.common.base.Preconditions;

public final class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    public static final String TOP_PATH = "..";
    public static final String CURRENT_PATH = ".";
    public static final String UNDER_LINE_SEPARATOR = "_";
    public static final String EMPTY_STRING = "";
    public static final char EXTENSION_SEPARATOR = '.';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final String LF = "\n";
    private static final Pattern BROWSWER_PATTERN = Pattern.compile(".*Gecko.*|.*AppleWebKit.*|.*Trident.*|.*Chrome.*");
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;

    public static boolean isBlank(String arg) {
        return StrUtil.isBlank(arg);
    }

    public static boolean isNotBlank(String arg) {
        return !StringUtils.isBlank(arg);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static String format(String format, Object ... args) {
        return StrUtil.format(format, args);
    }

    public static List<String> splitPath(String path) {
        return StrSplitter.splitPath(path);
    }

    public static List<String> splitToList(String str, String delimit) {
        return StrSplitter.split((CharSequence)str, delimit, true, false);
    }

    public static List<String> splitLimit(String str, String delimit, int limit) {
        return StrSplitter.split((CharSequence)str, delimit, limit, true, true);
    }

    public static TextStringBuilder getStringBuilder() {
        return new TextStringBuilder();
    }

    public static String decodeString(byte[] data) {
        if (data == null) {
            return EMPTY_STRING;
        }
        return StringUtils.toEncodedString(data, StandardCharsets.UTF_8);
    }

    public static String formatURL(String value, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = String.valueOf(args[i]);
            try {
                String encodeArg = URLEncoder.encode(arg, "UTF-8");
                args[i] = encodeArg;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return String.format(value, args);
    }

    public static String shellQuote(String s2, char quoteCh) {
        StringBuilder buf = new StringBuilder(s2.length() + 2);
        buf.append(quoteCh);
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            if (ch == quoteCh) {
                buf.append('\\');
            }
            buf.append(ch);
        }
        buf.append(quoteCh);
        return buf.toString();
    }

    public static boolean isFromBrowser(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return BROWSWER_PATTERN.matcher(userAgent).matches();
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    public static String bytes2String(byte[] bytes) {
        return StringUtils.bytes2String(bytes, 0, bytes.length);
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes(UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }

    public static String toStartupShutdownString(String prefix, String ... msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s2 : msg) {
            b.append(LF).append(prefix).append(s2);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static String appendIfNotPresent(String str, char c) {
        Preconditions.checkNotNull(str, "Input string is null");
        return str.isEmpty() || str.charAt(str.length() - 1) != c ? str + c : str;
    }

    public static Optional<String> ofBlankable(String str) {
        if (StringUtils.isBlank(str)) {
            return Optional.empty();
        }
        return Optional.of(str);
    }
}

