/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void sleep(TimeUnit timeUnit, int time) {
        try {
            timeUnit.sleep(time);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getStackTraceInfo(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            e.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e1) {
            return "";
        }
    }

    public static String getClassInfo() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTrace.length < 3 ? stackTrace[stackTrace.length - 1] : stackTrace[3];
        if (stackTraceElement != null) {
            sb.append(ThreadUtils.getSimpleClassName(stackTraceElement.getClassName())).append("#");
            sb.append(stackTraceElement.getMethodName()).append(":");
            sb.append(stackTraceElement.getLineNumber()).append(" ");
        }
        return sb.toString();
    }

    private static String getSimpleClassName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }
}

