/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.system.SystemUtil;
import cn.hutool.system.oshi.OshiUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hodor.common.utils.GsonUtils;
import oshi.hardware.GlobalMemory;

public class Utils {

    public static class Dates
    extends DateUtil {
        public static String PATTEN = "yyyy-MM-dd HH:mm:ss";
        public static String SIMPLE_PATTEN = "yyyyMMddHHmmss";

        public static long betweenMs(String startTime, String endTime) {
            if (StringUtils.isEmpty(endTime) || StringUtils.isEmpty(startTime)) {
                return 0L;
            }
            if (endTime.equals(startTime)) {
                return 0L;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(PATTEN);
            long processTime = 0L;
            if (!StringUtils.isNotEmpty(endTime) || !StringUtils.isNotEmpty(startTime)) {
                return processTime;
            }
            try {
                Date end = sdf.parse(endTime);
                Date start = sdf.parse(startTime);
                processTime = (end.getTime() - start.getTime()) / 1000L;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (processTime > 1400000000L) {
                processTime = 0L;
            }
            return processTime;
        }

        public static Date parseByYYYYMMDDPatten(String date) throws ParseException {
            if (StringUtils.isEmpty(date)) {
                return null;
            }
            SimpleDateFormat df = new SimpleDateFormat(SIMPLE_PATTEN);
            return df.parse(date);
        }
    }

    public static class Systems
    extends SystemUtil {
        public static Double getCpuUsage() {
            return OshiUtil.getCpuInfo().getUsed();
        }

        public static Double getMemUsage() {
            GlobalMemory memory = OshiUtil.getMemory();
            double memoryUsage = (double)(memory.getTotal() - memory.getAvailable()) * 1.0 / (double)memory.getTotal();
            return Systems.doubleFormat(memoryUsage);
        }

        public static Double getLoadAverage() {
            double loadAverage;
            block2: {
                try {
                    loadAverage = Systems.getOperatingSystemMXBean().getSystemLoadAverage();
                }
                catch (Exception e) {
                    loadAverage = OshiUtil.getHardware().getProcessor().getSystemLoadAverage(1)[0];
                    if (!Double.isNaN(loadAverage)) break block2;
                    return -1.0;
                }
            }
            return Systems.doubleFormat(loadAverage);
        }

        private static double doubleFormat(double rawValue) {
            DecimalFormat df = new DecimalFormat("0.00");
            df.setRoundingMode(RoundingMode.HALF_UP);
            return Double.parseDouble(df.format(rawValue));
        }
    }

    public static class Jsons
    extends JSONUtil {
        private static final Gson gson = GsonUtils.getGson();

        public static String toJson(Object obj) {
            return gson.toJson(obj);
        }

        public static <T> T toBean(String jsonStr, TypeReference<T> typeReference) {
            return Jsons.toBean(jsonStr, typeReference.getType());
        }

        public static <T> T toBean(String jsonStr, TypeToken<T> typeToken) {
            return Jsons.toBean(jsonStr, typeToken.getType());
        }

        public static <T> T toBean(String jsonStr, Type type) {
            return gson.fromJson(jsonStr, type);
        }
    }

    public static class Beans
    extends BeanUtil {
    }

    public static class Reflections
    extends ReflectUtil {
    }

    public static class Collections
    extends CollUtil {
    }

    public static class Https
    extends HttpUtil {
    }

    public static class Assert
    extends cn.hutool.core.lang.Assert {
        public static long validLong(String longStr, String errorMsgTemplate, String ... params) {
            long result;
            try {
                result = Long.parseLong(longStr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(StrUtil.format(errorMsgTemplate, params));
            }
            return result;
        }

        public static <T> T validParse(Supplier<? extends T> supplier, String errorMsgTemplate, String ... params) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(StrUtil.format(errorMsgTemplate, params));
            }
        }
    }
}

