/*
 * Copyright (c) 2025 Hutool Team and hutool.cn
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dromara.hutool.ai.core;

import java.util.List;

/**
 * 模型公共的API功能，特有的功能在model.xx.XXService下定义
 *
 * @author elichow
 * @since 6.0.0
 */
public interface AIService {

	/**
	 * 对话
	 *
	 * @param prompt user题词
	 * @return AI回答
	 * @since 6.0.0
	 */
	String chat(String prompt);

	/**
	 * 对话
	 *
	 * @param messages 由目前为止的对话组成的消息列表，可以设置role，content。详细参考官方文档
	 * @return AI回答
	 * @since 6.0.0
	 */
	String chat(final List<Message> messages);

}
