/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai;

import java.util.List;
import org.dromara.hutool.ai.AIServiceFactory;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.AIService;
import org.dromara.hutool.ai.core.Message;
import org.dromara.hutool.ai.model.deepseek.DeepSeekService;
import org.dromara.hutool.ai.model.doubao.DoubaoService;
import org.dromara.hutool.ai.model.grok.GrokService;
import org.dromara.hutool.ai.model.openai.OpenaiService;

public class AIUtil {
    public static <T extends AIService> T getAIService(AIConfig config, Class<T> clazz) {
        return AIServiceFactory.getAIService(config, clazz);
    }

    public static AIService getAIService(AIConfig config) {
        return AIUtil.getAIService(config, AIService.class);
    }

    public static DeepSeekService getDeepSeekService(AIConfig config) {
        return AIUtil.getAIService(config, DeepSeekService.class);
    }

    public static DoubaoService getDoubaoService(AIConfig config) {
        return AIUtil.getAIService(config, DoubaoService.class);
    }

    public static GrokService getGrokService(AIConfig config) {
        return AIUtil.getAIService(config, GrokService.class);
    }

    public static OpenaiService getOpenAIService(AIConfig config) {
        return AIUtil.getAIService(config, OpenaiService.class);
    }

    public static String chat(AIConfig config, String prompt) {
        return AIUtil.getAIService(config).chat(prompt);
    }

    public static String chat(AIConfig config, List<Message> messages) {
        return AIUtil.getAIService(config).chat(messages);
    }
}

