/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.model.doubao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.BaseAIService;
import org.dromara.hutool.ai.core.Message;
import org.dromara.hutool.ai.model.doubao.DoubaoCommon;
import org.dromara.hutool.ai.model.doubao.DoubaoService;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.json.JSONUtil;

public class DoubaoServiceImpl
extends BaseAIService
implements DoubaoService {
    private final String CHAT_ENDPOINT = "/chat/completions";
    private final String EMBEDDING_TEXT = "/embeddings";
    private final String EMBEDDING_VISION = "/embeddings/multimodal";
    private final String BOTS_CHAT = "/bots/chat/completions";
    private final String TOKENIZATION = "/tokenization";
    private final String BATCH_CHAT = "/batch/chat/completions";
    private final String CREATE_CONTEXT = "/context/create";
    private final String CHAT_CONTEXT = "/context/chat/completions";
    private final String CREATE_VIDEO = "/contents/generations/tasks";

    public DoubaoServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(String prompt) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("system", "You are a helpful assistant"));
        messages.add(new Message("user", prompt));
        return this.chat(messages);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public String chatVision(String prompt, List<String> images, String detail) {
        String paramJson = this.buildChatVisionRequestBody(prompt, images, detail);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public String videoTasks(String text, String image, List<DoubaoCommon.DoubaoVideo> videoParams) {
        String paramJson = this.buildGenerationsTasksRequestBody(text, image, videoParams);
        Response response = this.sendPost("/contents/generations/tasks", paramJson);
        return response.bodyStr();
    }

    @Override
    public String getVideoTasksInfo(String taskId) {
        Response response = this.sendGet("/contents/generations/tasks/" + taskId);
        return response.bodyStr();
    }

    @Override
    public String embeddingText(String[] input) {
        String paramJson = this.buildEmbeddingTextRequestBody(input);
        Response response = this.sendPost("/embeddings", paramJson);
        return response.bodyStr();
    }

    @Override
    public String embeddingVision(String text, String image) {
        String paramJson = this.buildEmbeddingVisionRequestBody(text, image);
        Response response = this.sendPost("/embeddings/multimodal", paramJson);
        return response.bodyStr();
    }

    @Override
    public String botsChat(List<Message> messages) {
        String paramJson = this.buildBotsChatRequestBody(messages);
        Response response = this.sendPost("/bots/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public String tokenization(String[] text) {
        String paramJson = this.buildTokenizationRequestBody(text);
        Response response = this.sendPost("/tokenization", paramJson);
        return response.bodyStr();
    }

    @Override
    public String batchChat(String prompt) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("system", "You are a helpful assistant"));
        messages.add(new Message("user", prompt));
        return this.batchChat(messages);
    }

    @Override
    public String batchChat(List<Message> messages) {
        String paramJson = this.buildBatchChatRequestBody(messages);
        Response response = this.sendPost("/batch/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public String createContext(List<Message> messages, String mode) {
        String paramJson = this.buildCreateContextRequest(messages, mode);
        Response response = this.sendPost("/context/create", paramJson);
        return response.bodyStr();
    }

    @Override
    public String chatContext(String prompt, String contextId) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("user", prompt));
        return this.chatContext(messages, contextId);
    }

    @Override
    public String chatContext(List<Message> messages, String contextId) {
        String paramJson = this.buildChatContentRequestBody(messages, contextId);
        Response response = this.sendPost("/context/chat/completions", paramJson);
        return response.bodyStr();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildChatVisionRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildEmbeddingTextRequestBody(String[] input) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("input", input);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildEmbeddingVisionRequestBody(String text, String image) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        ArrayList input = new ArrayList();
        if (!StrUtil.isBlank((CharSequence)text)) {
            HashMap<String, String> textMap = new HashMap<String, String>();
            textMap.put("type", "text");
            textMap.put("text", text);
            input.add(textMap);
        }
        if (!StrUtil.isBlank((CharSequence)image)) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", image);
            imgUrlMap.put("image_url", urlMap);
            input.add(imgUrlMap);
        }
        paramMap.put("input", input);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildBotsChatRequestBody(List<Message> messages) {
        return this.buildChatRequestBody(messages);
    }

    private String buildTokenizationRequestBody(String[] text) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("text", text);
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildBatchChatRequestBody(List<Message> messages) {
        return this.buildChatRequestBody(messages);
    }

    private String buildCreateContextRequest(List<Message> messages, String mode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("messages", messages);
        paramMap.put("model", this.config.getModel());
        paramMap.put("mode", mode);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildChatContentRequestBody(List<Message> messages, String contextId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.put("context_id", contextId);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildGenerationsTasksRequestBody(String text, String image, List<DoubaoCommon.DoubaoVideo> videoParams) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        ArrayList content = new ArrayList();
        HashMap<String, String> textMap = new HashMap<String, String>();
        if (!StrUtil.isBlank((CharSequence)text)) {
            textMap.put("type", "text");
            textMap.put("text", text);
            content.add(textMap);
        }
        if (!StrUtil.isNotBlank((CharSequence)image)) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", image);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        if (videoParams != null && !videoParams.isEmpty()) {
            if (textMap != null && !textMap.isEmpty()) {
                int textIndex = content.indexOf(textMap);
                StringBuilder textBuilder = new StringBuilder(text);
                for (DoubaoCommon.DoubaoVideo videoParam : videoParams) {
                    textBuilder.append(" ").append(videoParam.getType()).append(" ").append(videoParam.getValue());
                }
                textMap.put("type", "text");
                textMap.put("text", textBuilder.toString());
                if (textIndex != -1) {
                    content.set(textIndex, textMap);
                } else {
                    content.add(textMap);
                }
            } else {
                StringBuilder textBuilder = new StringBuilder();
                for (DoubaoCommon.DoubaoVideo videoParam : videoParams) {
                    textBuilder.append(videoParam.getType()).append(videoParam.getValue()).append(" ");
                }
                textMap.put("type", "text");
                textMap.put("text", textBuilder.toString());
                content.add(textMap);
            }
        }
        paramMap.put("content", content);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }
}

