/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai;

import java.util.Map;
import java.util.ServiceLoader;
import org.dromara.hutool.ai.AIException;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.AIService;
import org.dromara.hutool.ai.core.AIServiceProvider;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;

public class AIServiceFactory {
    private static final Map<String, AIServiceProvider> providers = new SafeConcurrentHashMap();

    public static AIService getAIService(AIConfig config) {
        return AIServiceFactory.getAIService(config, AIService.class);
    }

    public static <T extends AIService> T getAIService(AIConfig config, Class<T> clazz) {
        AIServiceProvider provider = providers.get(config.getModelName().toLowerCase());
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported model: " + config.getModelName());
        }
        Object service = provider.create(config);
        if (!clazz.isInstance(service)) {
            throw new AIException("Model service is not of type: " + clazz.getSimpleName());
        }
        return service;
    }

    static {
        ServiceLoader<AIServiceProvider> loader = ServiceLoader.load(AIServiceProvider.class);
        for (AIServiceProvider provider : loader) {
            providers.put(provider.getServiceName().toLowerCase(), provider);
        }
    }
}

