/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.function.Consumer;
import org.dromara.hutool.ai.AIException;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.Method;
import org.dromara.hutool.json.JSONUtil;

public class BaseAIService {
    protected final AIConfig config;

    public BaseAIService(AIConfig config) {
        this.config = config;
    }

    protected Response sendGet(String endpoint) {
        try {
            HttpGlobalConfig.setTimeout((int)this.config.getTimeout());
            return ((Request)((Request)HttpUtil.createRequest((String)(this.config.getApiUrl() + endpoint), (Method)Method.GET).header(HeaderName.ACCEPT, "application/json")).header(HeaderName.AUTHORIZATION, "Bearer " + this.config.getApiKey())).send();
        }
        catch (AIException e) {
            throw new AIException("Failed to send GET request: " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected Response sendPost(String endpoint, String paramJson) {
        try {
            HttpGlobalConfig.setTimeout((int)this.config.getTimeout());
            return ((Request)((Request)((Request)HttpUtil.createRequest((String)(this.config.getApiUrl() + endpoint), (Method)Method.POST).header(HeaderName.CONTENT_TYPE, "application/json")).header(HeaderName.ACCEPT, "application/json")).header(HeaderName.AUTHORIZATION, "Bearer " + this.config.getApiKey())).body(paramJson).send();
        }
        catch (AIException e) {
            throw new AIException("Failed to send POST request\uff1a" + e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected Response sendFormData(String endpoint, Map<String, Object> paramMap) {
        try {
            HttpGlobalConfig.setTimeout((int)this.config.getTimeout());
            return ((Request)HttpUtil.createPost((String)(this.config.getApiUrl() + endpoint)).header(HeaderName.AUTHORIZATION, "Bearer " + this.config.getApiKey())).form(paramMap).send();
        }
        catch (AIException e) {
            throw new AIException("Failed to send POST request\uff1a" + e.getMessage(), (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPostStream(String endpoint, Map<String, Object> paramMap, Consumer<String> callback) {
        HttpURLConnection connection = null;
        try {
            URL apiUrl = new URL(this.config.getApiUrl() + endpoint);
            connection = (HttpURLConnection)apiUrl.openConnection();
            connection.setRequestMethod(Method.POST.name());
            connection.setRequestProperty(HeaderName.CONTENT_TYPE.getValue(), "application/json");
            connection.setRequestProperty(HeaderName.AUTHORIZATION.getValue(), "Bearer " + this.config.getApiKey());
            connection.setDoOutput(true);
            connection.setReadTimeout(this.config.getReadTimeout());
            connection.setConnectTimeout(this.config.getTimeout());
            try (OutputStream os = connection.getOutputStream();){
                String jsonInputString = JSONUtil.toJsonStr(paramMap);
                os.write(jsonInputString.getBytes());
                os.flush();
            }
            var7_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    callback.accept(line);
                }
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            callback.accept("{\"error\": \"" + e.getMessage() + "\"}");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

