/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.model.hutool;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dromara.hutool.ai.AIException;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.BaseAIService;
import org.dromara.hutool.ai.core.Message;
import org.dromara.hutool.ai.model.hutool.HutoolCommon;
import org.dromara.hutool.ai.model.hutool.HutoolService;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.json.JSONUtil;

public class HutoolServiceImpl
extends BaseAIService
implements HutoolService {
    private final String CHAT_ENDPOINT = "/chat/completions";
    private final String TOKENIZE_TEXT = "/tokenize/text";
    private final String IMAGES_GENERATIONS = "/images/generations";
    private final String EMBEDDING_VISION = "/embeddings/multimodal";
    private final String TTS = "/audio/tts";
    private final String STT = "/audio/stt";
    private final String CREATE_VIDEO = "/video/generations";

    public HutoolServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chat(List<Message> messages, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatStreamRequestBody(messages);
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), (String)"hutool-chat-sse").start();
    }

    @Override
    public String chatVision(String prompt, List<String> images, String detail) {
        String paramJson = this.buildChatVisionRequestBody(prompt, images, detail);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chatVision(String prompt, List<String> images, String detail, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatVisionStreamRequestBody(prompt, images, detail);
        System.out.println(JSONUtil.toJsonStr(paramMap));
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), (String)"hutool-chatVision-sse").start();
    }

    @Override
    public String tokenizeText(String text) {
        String paramJson = this.buildTokenizeRequestBody(text);
        Response response = this.sendPost("/tokenize/text", paramJson);
        return response.bodyStr();
    }

    @Override
    public String imagesGenerations(String prompt) {
        String paramJson = this.buildImagesGenerationsRequestBody(prompt);
        Response response = this.sendPost("/images/generations", paramJson);
        return response.bodyStr();
    }

    @Override
    public String embeddingVision(String text, String image) {
        String paramJson = this.buildEmbeddingVisionRequestBody(text, image);
        Response response = this.sendPost("/embeddings/multimodal", paramJson);
        return response.bodyStr();
    }

    @Override
    public InputStream tts(String input, HutoolCommon.HutoolSpeech voice) {
        try {
            String paramJson = this.buildTTSRequestBody(input, voice.getVoice());
            Response response = this.sendPost("/audio/tts", paramJson);
            String contentType = response.header("Content-Type");
            if (contentType != null && contentType.startsWith("application/json")) {
                String errorBody = response.bodyStr();
                throw new AIException("TTS\u8bf7\u6c42\u5931\u8d25: " + errorBody);
            }
            return response.bodyStream();
        }
        catch (Exception e) {
            throw new AIException("TTS\u5904\u7406\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public String stt(File file) {
        Map<String, Object> paramMap = this.buildSTTRequestBody(file);
        Response response = this.sendFormData("/audio/stt", paramMap);
        return response.bodyStr();
    }

    @Override
    public String videoTasks(String text, String image, List<HutoolCommon.HutoolVideo> videoParams) {
        String paramJson = this.buildGenerationsTasksRequestBody(text, image, videoParams);
        Response response = this.sendPost("/video/generations", paramJson);
        return response.bodyStr();
    }

    @Override
    public String getVideoTasksInfo(String taskId) {
        Response response = this.sendGet("/video/generations/" + taskId);
        return response.bodyStr();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatStreamRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildChatVisionRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatVisionStreamRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildTokenizeRequestBody(String text) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("text", text);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildImagesGenerationsRequestBody(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildEmbeddingVisionRequestBody(String text, String image) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        ArrayList input = new ArrayList();
        if (!StrUtil.isBlank((CharSequence)text)) {
            HashMap<String, String> textMap = new HashMap<String, String>();
            textMap.put("type", "text");
            textMap.put("text", text);
            input.add(textMap);
        }
        if (!StrUtil.isBlank((CharSequence)image)) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", image);
            imgUrlMap.put("image_url", urlMap);
            input.add(imgUrlMap);
        }
        paramMap.put("input", input);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        System.out.println(JSONUtil.toJsonStr(paramMap));
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildTTSRequestBody(String input, String voice) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("input", input);
        paramMap.put("voice", voice);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildSTTRequestBody(File file) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("file", file);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildGenerationsTasksRequestBody(String text, String image, List<HutoolCommon.HutoolVideo> videoParams) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        ArrayList content = new ArrayList();
        HashMap<String, String> textMap = new HashMap<String, String>();
        if (!StrUtil.isBlank((CharSequence)text)) {
            textMap.put("type", "text");
            textMap.put("text", text);
            content.add(textMap);
        }
        if (!StrUtil.isBlank((CharSequence)image)) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", image);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        if (videoParams != null && !videoParams.isEmpty()) {
            if (textMap != null && !textMap.isEmpty()) {
                int textIndex = content.indexOf(textMap);
                StringBuilder textBuilder = new StringBuilder(text);
                for (HutoolCommon.HutoolVideo videoParam : videoParams) {
                    textBuilder.append(" ").append(videoParam.getType()).append(" ").append(videoParam.getValue());
                }
                textMap.put("type", "text");
                textMap.put("text", textBuilder.toString());
                if (textIndex != -1) {
                    content.set(textIndex, textMap);
                } else {
                    content.add(textMap);
                }
            } else {
                StringBuilder textBuilder = new StringBuilder();
                for (HutoolCommon.HutoolVideo videoParam : videoParams) {
                    textBuilder.append(videoParam.getType()).append(videoParam.getValue()).append(" ");
                }
                textMap.put("type", "text");
                textMap.put("text", textBuilder.toString());
                content.add(textMap);
            }
        }
        paramMap.put("content", content);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        System.out.println(JSONUtil.toJsonStr(paramMap));
        return JSONUtil.toJsonStr(paramMap);
    }
}

