/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.dromara.hutool.core.cache.Cache;
import org.dromara.hutool.core.cache.CacheListener;
import org.dromara.hutool.core.cache.impl.CacheObj;
import org.dromara.hutool.core.cache.impl.CacheObjIterator;
import org.dromara.hutool.core.cache.impl.CacheValuesIterator;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.lang.mutable.Mutable;
import org.dromara.hutool.core.lang.mutable.MutableObj;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 1L;
    protected Map<Mutable<K>, CacheObj<K, V>> cacheMap;
    protected final Map<K, Lock> keyLockMap = new SafeConcurrentHashMap<K, Lock>();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected LongAdder hitCount = new LongAdder();
    protected LongAdder missCount = new LongAdder();
    protected CacheListener<K, V> listener;

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    protected void putWithoutLock(K key, V object, long timeout) {
        CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put(MutableObj.of(key), co);
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    @Override
    public V get(K key, boolean isUpdateLastAccess, SerSupplier<V> supplier) {
        return this.get(key, isUpdateLastAccess, this.timeout, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess, long timeout, SerSupplier<V> supplier) {
        Object v = this.get(key, isUpdateLastAccess);
        if (null == v && null != supplier) {
            Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
            keyLock.lock();
            try {
                CacheObj<K, V> co = this.getWithoutLock(key);
                if (null == co || co.isExpired()) {
                    v = supplier.get();
                    this.put(key, v, timeout);
                } else {
                    v = co.get(isUpdateLastAccess);
                }
            }
            finally {
                keyLock.unlock();
                this.keyLockMap.remove(key);
            }
        }
        return v;
    }

    protected CacheObj<K, V> getWithoutLock(K key) {
        return this.cacheMap.get(MutableObj.of(key));
    }

    @Override
    public Iterator<V> iterator() {
        CacheObjIterator copiedIterator = (CacheObjIterator)this.cacheObjIterator();
        return new CacheValuesIterator(copiedIterator);
    }

    protected abstract int pruneCache();

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    public Set<K> keySet() {
        return this.cacheMap.keySet().stream().map(Mutable::get).collect(Collectors.toSet());
    }

    protected void onRemove(K key, V cachedObject) {
        CacheListener<K, V> listener = this.listener;
        if (null != listener) {
            listener.onRemove(key, cachedObject);
        }
    }

    protected CacheObj<K, V> removeWithoutLock(K key) {
        return this.cacheMap.remove(MutableObj.of(key));
    }

    protected Iterator<CacheObj<K, V>> cacheObjIter() {
        return this.cacheMap.values().iterator();
    }
}

