/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.comparator;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.dromara.hutool.core.comparator.NullComparator;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.split.SplitUtil;

public class VersionComparator
extends NullComparator<String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN_PRE_NUMBERS = Pattern.compile("^\\d+");
    public static final VersionComparator INSTANCE = new VersionComparator();

    public VersionComparator() {
        this(false);
    }

    public VersionComparator(boolean nullGreater) {
        super(nullGreater, VersionComparator::compareVersion);
    }

    private static int compareVersion(String version1, String version2) {
        List<String> v1s = SplitUtil.splitTrim(version1, ".");
        List<String> v2s = SplitUtil.splitTrim(version2, ".");
        int diff = 0;
        int minSize = Math.min(v1s.size(), v2s.size());
        for (int i = 0; i < minSize; ++i) {
            int v2Num;
            int v1Num;
            int diff1;
            String v1 = v1s.get(i);
            String v2 = v2s.get(i);
            diff = v1.length() - v2.length();
            if (0 == diff) {
                diff = v1.compareTo(v2);
            } else if (!(NumberUtil.isNumber(v1) && NumberUtil.isNumber(v2) || (diff1 = (v1Num = Convert.toInt(ReUtil.get(PATTERN_PRE_NUMBERS, (CharSequence)v1, 0), 0).intValue()) - (v2Num = Convert.toInt(ReUtil.get(PATTERN_PRE_NUMBERS, (CharSequence)v2, 0), 0).intValue())) == 0)) {
                diff = diff1;
            }
            if (diff != 0) break;
        }
        return diff != 0 ? diff : v1s.size() - v2s.size();
    }
}

