/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date.format.parser;

import org.dromara.hutool.core.date.DateException;
import org.dromara.hutool.core.date.DatePattern;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.format.DefaultDateBasic;
import org.dromara.hutool.core.date.format.parser.PredicateDateParser;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ISO8601DateParser
extends DefaultDateBasic
implements PredicateDateParser {
    private static final long serialVersionUID = 1L;
    public static ISO8601DateParser INSTANCE = new ISO8601DateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return StrUtil.contains(dateStr, 'T');
    }

    @Override
    public DateTime parse(String source) throws DateException {
        int length = source.length();
        if (StrUtil.contains((CharSequence)source, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return new DateTime((CharSequence)source, DatePattern.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength && length >= patternLength - 6) {
                return new DateTime((CharSequence)source, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (StrUtil.contains((CharSequence)source, '+')) {
                String zoneOffset = StrUtil.subAfter((CharSequence)(source = source.replace(" +", "+")), '+', true);
                if (StrUtil.isBlank(zoneOffset)) {
                    throw new DateException("Invalid format: [{}]", source);
                }
                if (!StrUtil.contains((CharSequence)zoneOffset, ':')) {
                    String pre = StrUtil.subBefore((CharSequence)source, '+', true);
                    source = pre + "+" + zoneOffset.substring(0, 2) + ":00";
                }
                if (StrUtil.contains((CharSequence)source, '.')) {
                    source = ISO8601DateParser.normalizeMillSeconds(source, ".", "+");
                    return new DateTime((CharSequence)source, DatePattern.ISO8601_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, DatePattern.ISO8601_WITH_XXX_OFFSET_FORMAT);
            }
            if (ReUtil.contains("-\\d{2}:?00", (CharSequence)source)) {
                if (':' != (source = source.replace(" -", "-")).charAt(source.length() - 3)) {
                    source = source.substring(0, source.length() - 2) + ":00";
                }
                if (StrUtil.contains((CharSequence)source, '.')) {
                    source = ISO8601DateParser.normalizeMillSeconds(source, ".", "-");
                    return new DateTime((CharSequence)source, DatePattern.ISO8601_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, DatePattern.ISO8601_WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return new DateTime((CharSequence)source, DatePattern.ISO8601_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 5) {
                return new DateTime((CharSequence)(source + ":00"), DatePattern.ISO8601_FORMAT);
            }
            if (StrUtil.contains((CharSequence)source, '.')) {
                source = ISO8601DateParser.normalizeMillSeconds(source, ".", null);
                return new DateTime((CharSequence)source, DatePattern.ISO8601_MS_FORMAT);
            }
        }
        throw new DateException("No UTC format fit for date String [{}] !", source);
    }

    private static String normalizeMillSeconds(String dateStr, CharSequence before, CharSequence after) {
        if (StrUtil.isBlank(after)) {
            String millOrNaco = StrUtil.subPre(StrUtil.subAfter((CharSequence)dateStr, before, true), 3);
            return StrUtil.subBefore((CharSequence)dateStr, before, true) + before + millOrNaco;
        }
        String millOrNaco = StrUtil.subPre(StrUtil.subBetween(dateStr, before, after), 3);
        return StrUtil.subBefore((CharSequence)dateStr, before, true) + before + millOrNaco + after + StrUtil.subAfter((CharSequence)dateStr, after, true);
    }
}

