/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect;

import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.dialect.DriverNamePool;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.dialect.impl.H2Dialect;
import org.dromara.hutool.db.dialect.impl.MysqlDialect;
import org.dromara.hutool.db.dialect.impl.OracleDialect;
import org.dromara.hutool.db.dialect.impl.PhoenixDialect;
import org.dromara.hutool.db.dialect.impl.PostgresqlDialect;
import org.dromara.hutool.db.dialect.impl.SqlServer2012Dialect;
import org.dromara.hutool.db.dialect.impl.Sqlite3Dialect;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.log.LogUtil;

public class DialectFactory
implements DriverNamePool {
    private static final Map<DataSource, Dialect> DIALECT_POOL = new SafeConcurrentHashMap<DataSource, Dialect>();

    private DialectFactory() {
    }

    public static Dialect newDialect(String driverName) {
        Dialect dialect = DialectFactory.internalNewDialect(driverName);
        LogUtil.debug("Use Dialect: [{}].", dialect.getClass().getSimpleName());
        return dialect;
    }

    private static Dialect internalNewDialect(String driverName) {
        if (StrUtil.isNotBlank(driverName)) {
            if ("com.mysql.jdbc.Driver".equalsIgnoreCase(driverName) || "com.mysql.cj.jdbc.Driver".equalsIgnoreCase(driverName)) {
                return new MysqlDialect();
            }
            if ("oracle.jdbc.OracleDriver".equalsIgnoreCase(driverName) || "oracle.jdbc.driver.OracleDriver".equalsIgnoreCase(driverName)) {
                return new OracleDialect();
            }
            if ("org.sqlite.JDBC".equalsIgnoreCase(driverName)) {
                return new Sqlite3Dialect();
            }
            if ("org.postgresql.Driver".equalsIgnoreCase(driverName)) {
                return new PostgresqlDialect();
            }
            if ("org.h2.Driver".equalsIgnoreCase(driverName)) {
                return new H2Dialect();
            }
            if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equalsIgnoreCase(driverName)) {
                return new SqlServer2012Dialect();
            }
            if ("org.apache.phoenix.jdbc.PhoenixDriver".equalsIgnoreCase(driverName)) {
                return new PhoenixDialect();
            }
        }
        return new AnsiSqlDialect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect getDialect(DataSource ds) {
        Dialect dialect = DIALECT_POOL.get(ds);
        if (null == dialect) {
            DataSource dataSource = ds;
            synchronized (dataSource) {
                dialect = DIALECT_POOL.computeIfAbsent(ds, DialectFactory::newDialect);
            }
        }
        return dialect;
    }

    public static Dialect newDialect(DataSource ds) {
        return DialectFactory.newDialect(DriverUtil.identifyDriver(ds));
    }

    public static Dialect newDialect(Connection conn) {
        return DialectFactory.newDialect(DriverUtil.identifyDriver(conn));
    }
}

