/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.sql.SqlBuilder;

public class OracleDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 6122761762247483015L;
    private static final String DEFAULT_TABLE_ALIAS = "table_alias_";
    private static final String DEFAULT_ROW_ALIAS = "row_";
    private static final String DEFAULT_ROWNUM_ALIAS = "rownum_";

    public static boolean isNextVal(Object value) {
        return value instanceof CharSequence && StrUtil.endWithIgnoreCase(value.toString(), ".nextval");
    }

    @Override
    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        int[] startEnd = page.getStartEnd();
        String sql = find.toString();
        String tableAlias = DEFAULT_TABLE_ALIAS;
        while (sql.contains(tableAlias)) {
            tableAlias = tableAlias + "_";
        }
        String rowAlias = DEFAULT_ROW_ALIAS;
        while (sql.contains(rowAlias)) {
            rowAlias = rowAlias + "_";
        }
        String rownumAlias = DEFAULT_ROWNUM_ALIAS;
        while (sql.contains(rownumAlias)) {
            rownumAlias = rownumAlias + "_";
        }
        return find.insertPreFragment("SELECT * FROM ( SELECT " + rowAlias + ".*, rownum " + rownumAlias + " from ( ").append(" ) row_ where rownum <= ").append(startEnd[1]).append(") ").append(tableAlias).append(" where ").append(tableAlias).append(".rownum_ > ").append(startEnd[0]);
    }

    @Override
    public String dialectName() {
        return DialectName.ORACLE.name();
    }
}

